/*
 * Decompiled with CFR 0.152.
 */
package jehep.io;

import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jehep.ui.mainGUI;
import jehep.utils.Utils;

public class ZipAs {
    private mainGUI win;
    private JFileChooser jChooser = new JFileChooser();
    private Utils Utils;

    public ZipAs(mainGUI win, String g, Document doc2) {
        this.win = win;
        this.Utils = new Utils(win);
        this.jChooser.setDialogTitle("Zip Document As..");
        this.jChooser.setApproveButtonText("Zip it!");
        this.run(g, doc2);
    }

    public void run(String g, Document doc2) {
        String zipFile = new String();
        String newline = new String();
        if (g == null || g == "") {
            jehep.utils.Utils.userMessage("Warning", "Please save file", 1);
            return;
        }
        this.jChooser.rescanCurrentDirectory();
        if (0 != this.jChooser.showSaveDialog(this.win)) {
            return;
        }
        zipFile = this.jChooser.getSelectedFile().getPath();
        this.win.repaint();
        try {
            this.win.setWaitCursor();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            out.putNextEntry(new ZipEntry(new File(g).getName()));
            newline = System.getProperty("line.separator");
            Element map = doc2.getDefaultRootElement();
            for (int i = 0; i < map.getElementCount(); ++i) {
                Element line = map.getElement(i);
                int start = line.getStartOffset();
                byte[] buf = (doc2.getText(start, line.getEndOffset() - start - 1) + newline).getBytes();
                out.write(buf, 0, buf.length);
            }
            out.closeEntry();
            out.close();
            this.win.setTextCursor();
        }
        catch (Exception ioe) {
            this.win.setStatus("IOException " + ioe + " occurred");
        }
    }
}

