/*
 * Decompiled with CFR 0.152.
 */
package jehep.gnu.regexp;

import java.util.Vector;
import jehep.gnu.regexp.CharIndexed;
import jehep.gnu.regexp.REMatch;
import jehep.gnu.regexp.REToken;
import jehep.gnu.regexp.RETokenChar;

final class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;

    RETokenOneOf(int subIndex, String optionsStr, boolean negative, boolean insens) {
        super(subIndex);
        this.options = new Vector();
        this.negative = negative;
        for (int i = 0; i < optionsStr.length(); ++i) {
            this.options.addElement(new RETokenChar(subIndex, optionsStr.charAt(i), insens));
        }
    }

    RETokenOneOf(int subIndex, Vector options, boolean negative) {
        super(subIndex);
        this.options = options;
        this.negative = negative;
    }

    @Override
    int getMinimumLength() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.options.size(); ++i) {
            int x = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (x >= min) continue;
            min = x;
        }
        return min;
    }

    @Override
    boolean match(CharIndexed input, REMatch mymatch) {
        if (this.negative && input.charAt(mymatch.index) == '\uffff') {
            return false;
        }
        REMatch newMatch = null;
        REMatch last = null;
        for (int i = 0; i < this.options.size(); ++i) {
            REMatch tryMatch;
            REToken tk = (REToken)this.options.elementAt(i);
            if (!tk.match(input, tryMatch = (REMatch)mymatch.clone())) continue;
            if (this.negative) {
                return false;
            }
            if (!this.next(input, tryMatch)) continue;
            if (last == null) {
                newMatch = tryMatch;
                last = tryMatch;
                continue;
            }
            last.next = tryMatch;
            last = tryMatch;
        }
        if (newMatch != null) {
            if (this.negative) {
                return false;
            }
            mymatch.assignFrom(newMatch);
            return true;
        }
        if (this.negative) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    @Override
    void dump(StringBuffer os) {
        os.append(this.negative ? "[^" : "(?:");
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.negative && i > 0) {
                os.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(os);
        }
        os.append(this.negative ? (char)']' : ')');
    }
}

