/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.util.HashMap;
import jehep.fbrowser.FBException;

public abstract class Loadable {
    Object id;
    boolean shouldCache = false;
    static HashMap cache = new HashMap();
    boolean loaded = false;

    public Loadable(Object id, boolean shouldCache) {
        this.id = id;
        this.shouldCache = shouldCache;
    }

    public Loadable(Object id) {
        this(id, false);
    }

    public Loadable load() throws FBException {
        if (this.shouldCache && cache.containsKey(this.id)) {
            return (Loadable)cache.get(this.id);
        }
        if (!this.loaded) {
            this.loadIt();
            this.loaded = true;
            if (this.shouldCache) {
                cache.put(this.id, this);
            }
        }
        return this;
    }

    public void reload() throws FBException {
        this.loadIt();
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected abstract void loadIt() throws FBException;

    public Object getId() {
        return this.id;
    }
}

