/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import jehep.fbrowser.FBException;
import jehep.fbrowser.FileInterface;
import jehep.fbrowser.MergeSort;

public class FileWrapper
extends FileInterface {
    private File file;
    private static MergeSort fileMS = new MergeSort(){

        @Override
        public int compareElementsAt(int a, int b) {
            return this.toSort[a].toString().compareTo(this.toSort[b].toString());
        }
    };

    public FileWrapper(FileWrapper parent, File f) throws FBException {
        super(parent);
        this.file = f;
    }

    public FileWrapper(FileWrapper parent, String fullPath) throws FBException {
        this(parent, new File(fullPath));
    }

    @Override
    public void refresh() throws FBException {
        if (this.children != null) {
            this.reloadChildren();
        }
    }

    @Override
    public void loadChildrenDoIt() throws FBException {
        Object[] files = this.file.listFiles();
        if (files == null) {
            return;
        }
        fileMS.sort(files);
        this.children = new FileWrapper[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.children[i] = new FileWrapper(this, (File)files[i]);
        }
    }

    @Override
    public void copyImpl(String destFullPath) throws FBException {
        if (this.isDirectory()) {
            this.copyChildren(destFullPath);
        }
    }

    @Override
    public void moveImpl(String destPath) throws FBException {
        this.file.renameTo(new File(destPath + File.separator + this.getName()));
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getLastMod() {
        String smod;
        SimpleDateFormat formatter = new SimpleDateFormat(" MM/dd/yy HH:mm");
        SimpleDateFormat formatter2 = new SimpleDateFormat(" HH:mm");
        String tmp = formatter.format(this.file.lastModified());
        String tmp1 = formatter2.format(this.file.lastModified());
        SimpleDateFormat form1 = new SimpleDateFormat("yyyy MMM dd");
        String stoday = form1.format((Object)new Date());
        if (stoday.equals(smod = form1.format(this.file.lastModified()))) {
            tmp = "Today " + tmp1;
        }
        return tmp;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return !this.file.isDirectory();
    }

    @Override
    public void mkdirImpl(String dirname) throws FBException {
        if (!this.isDirectory()) {
            this.signalError("Could not create a directory. The file " + this.getPath() + " is not a directory.");
        } else {
            File f = new File(this.file.getPath() + File.separator + dirname);
            if (!f.mkdirs()) {
                this.signalError("Could not create a directory " + dirname);
            }
        }
    }

    @Override
    public void removeImpl() throws FBException {
        if (this.isDirectory()) {
            this.removeDirectory();
        }
        try {
            if (!this.file.delete()) {
                this.signalError("Could not delete file: " + this.getPath());
            }
        }
        catch (SecurityException e) {
            this.signalError("Error occurred when deleting the file: " + this.getPath() + " [" + e.getMessage() + "]");
        }
    }

    @Override
    public void renameInPlaceImpl(String newName) throws FBException {
        String newPath;
        File parentFile = this.file.getParentFile();
        String parentPath = "";
        if (parentFile != null) {
            parentPath = parentFile.getPath();
        }
        if (!this.file.renameTo(new File(newPath = parentPath + File.separator + newName))) {
            this.signalError("Could not rename the file " + this.file.getPath() + " to " + newPath);
        }
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isRegularFile() {
        return true;
    }
}

