/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import jehep.fbrowser.FBException;

public abstract class FileInterface {
    protected FileInterface parentFile;
    protected FileInterface[] children;
    boolean loadingChildrenFailed = false;

    protected FileInterface(FileInterface parent) {
        this.parentFile = parent;
        this.children = null;
    }

    public FileInterface getParent() {
        return this.parentFile;
    }

    public abstract void refresh() throws FBException;

    public abstract void removeImpl() throws FBException;

    public void remove() throws FBException {
        this.removeImpl();
        if (this.parentFile != null) {
            this.parentFile.reloadChildren();
        }
    }

    public void mkdir(String dirname) throws FBException {
        this.mkdirImpl(dirname);
        this.reloadChildren();
    }

    public abstract void mkdirImpl(String var1) throws FBException;

    public void copy(FileInterface file2) throws FBException {
        this.copyImpl(file2.getPath());
        file2.reloadChildren();
    }

    public abstract void copyImpl(String var1) throws FBException;

    public void move(FileInterface target) throws FBException {
        if (this.isCastorFile() && !target.isCastorFile() || !this.isCastorFile() && target.isCastorFile()) {
            throw new FBException("Can't move between filesystems.");
        }
        this.moveImpl(target.getPath());
        target.reloadChildren();
        if (this.getParent() != null) {
            this.getParent().reloadChildren();
        }
    }

    public abstract void moveImpl(String var1) throws FBException;

    public void renameInPlace(String newName) throws FBException {
        this.renameInPlaceImpl(newName);
        this.parentFile.reloadChildren();
    }

    public abstract void renameInPlaceImpl(String var1) throws FBException;

    protected void copyChildren(String destFullPath) throws FBException {
        this.assureChildrenLoaded();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].copyImpl(destFullPath + File.separator + this.getName());
            }
        }
    }

    protected void removeDirectory() throws FBException {
        this.assureChildrenLoaded();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].removeImpl();
            }
        }
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract String getPath();

    public abstract String getName();

    public abstract String getLastMod();

    public abstract long getLength();

    protected void loadChildren() throws FBException {
        this.loadChildrenDoIt();
        this.loadingChildrenFailed = false;
    }

    protected abstract void loadChildrenDoIt() throws FBException;

    public boolean areChildrenLoaded() {
        return this.children != null;
    }

    public void reloadChildren() throws FBException {
        this.children = null;
        this.loadChildren();
    }

    public void assureChildrenLoaded() throws FBException {
        if (this.children == null) {
            this.loadChildren();
        }
    }

    public void loadingChildrenFailed() {
        this.loadingChildrenFailed = true;
        this.children = new FileInterface[0];
    }

    public boolean isLoadingChildrenFailed() {
        return this.loadingChildrenFailed;
    }

    public FileInterface[] getChildren() {
        return this.children;
    }

    protected void signalError(String msg) throws FBException {
        if (msg != null) {
            throw new FBException(msg);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileInterface)) {
            return false;
        }
        FileInterface file2 = (FileInterface)obj;
        if (this.getPath() == null) {
            return file2.getPath() == null;
        }
        return this.getPath().equals(file2.getPath()) && this.isCastorFile() == file2.isCastorFile();
    }

    public boolean isCastorFile() {
        return false;
    }

    public boolean isRegularFile() {
        return false;
    }

    public Object[] getPathForEvents(boolean includeFile) {
        FileInterface walker;
        Vector<FileInterface> path = new Vector<FileInterface>();
        FileInterface fileInterface = walker = includeFile ? this : this.parentFile;
        while (walker != null) {
            path.addElement(walker);
            walker = walker.getParent();
        }
        Object[] pathArr = new Object[path.size()];
        int idx = pathArr.length - 1;
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            pathArr[idx] = iter.next();
            --idx;
        }
        return pathArr;
    }

    public int getChildNr(FileInterface child) {
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    protected boolean hasChildernWithName(String name) throws FBException {
        if (this.children == null) {
            this.assureChildrenLoaded();
        }
        for (int i = 0; i < this.children.length; ++i) {
            String n = this.children[i].getName();
            if ((n != null || name != null) && (n == null || !n.equals(name))) continue;
            return true;
        }
        return false;
    }
}

