/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.awt.Dimension;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class Consts {
    public static final String PROGRAM = "CastorBrowser";
    private static final String HOME_PATH = "/castor/cern.ch/user";
    public static int FOLDER_SIZE_WARNING_TRESHOLD = 100;
    public static final String ABOUT_PATH = "/resources/about.html";
    public static final Dimension ABOUT_DIMENSION = new Dimension(400, 250);
    public static final String HELP_PATH = "/resources/help/help.html";
    public static final Dimension HELP_DIMENSION = new Dimension(500, 400);
    private static SimpleDateFormat outDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat inDateFormat_Year = new SimpleDateFormat("MMMddyyyy");
    private static SimpleDateFormat inDateFormat_Hour = new SimpleDateFormat("MMMddkk:mm");
    public static final char READ_OK = 'r';
    public static final char WRITE_OK = 'w';
    public static final char EXEC_OK = 'x';
    public static final char NO = '-';
    public static final boolean DEBUG_MODE = false;

    public static final String getCastorHomePath() {
        String userName = System.getProperty("user.name");
        return HOME_PATH + File.separator + userName.charAt(0) + File.separator + userName;
    }

    public static final String getRegularHomePath() {
        return System.getProperty("user.home");
    }

    public static String formatDate(long date) {
        return outDateFormat.format(new Date(date));
    }

    public static String formatDate(Date date) {
        return outDateFormat.format(date);
    }

    public static long parseDate(String date) {
        Date d = null;
        try {
            if (date.indexOf(58) < 0) {
                d = inDateFormat_Year.parse(date);
            } else {
                d = inDateFormat_Hour.parse(date);
                Calendar c = Calendar.getInstance();
                int currentYear = c.get(1);
                c.setTime(d);
                c.set(1, currentYear);
                d = c.getTime();
            }
        }
        catch (ParseException pe) {
            d = new Date(0L);
        }
        return d.getTime();
    }

    public static final String convertPermissions(String unixPermString) {
        int[] permNr = new int[]{0, 0, 0};
        for (int i = 0; i < 3; ++i) {
            permNr[i] = (unixPermString.charAt(3 * i) == '-' ? 0 : 4) + (unixPermString.charAt(3 * i + 1) == '-' ? 0 : 2) + (unixPermString.charAt(3 * i + 2) == '-' ? 0 : 1);
        }
        return "" + permNr[0] + permNr[1] + permNr[2];
    }

    public static final void debug(String msg) {
    }
}

