/*
 * Decompiled with CFR 0.152.
 */
package jabref.labelPattern;

import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.Globals;
import jabref.Util;
import jabref.imports.ImportFormatReader;
import jabref.labelPattern.LabelPattern;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LabelPatternUtil {
    private static ArrayList letters = LabelPatternUtil.builtLetters();
    public static ArrayList DEFAULT_LABELPATTERN = LabelPatternUtil.split("[auth][year]");
    private static BibtexDatabase _db;

    public static ArrayList split(String labelPattern) {
        ArrayList<String> _alist = new ArrayList<String>();
        _alist.add(labelPattern);
        StringTokenizer tok = new StringTokenizer(labelPattern, "[]", true);
        while (tok.hasMoreTokens()) {
            _alist.add(tok.nextToken());
        }
        return _alist;
    }

    public static BibtexEntry makeLabel(LabelPattern table, BibtexDatabase database, BibtexEntry _entry) {
        _db = database;
        StringBuffer _sb = new StringBuffer();
        boolean forceUpper = false;
        boolean forceLower = false;
        try {
            String _type = _entry.getType().getName().toLowerCase();
            ArrayList _al = table.getValue(_type);
            int _alSize = _al.size();
            boolean field = false;
            for (int i = 1; i < _alSize; ++i) {
                String val = _al.get(i).toString();
                if (val.equals("[")) {
                    field = true;
                    continue;
                }
                if (val.equals("]")) {
                    field = false;
                    continue;
                }
                if (field) {
                    String modifier = null;
                    int _mi = val.indexOf(":");
                    if (_mi != -1 && _mi != val.length() - 1 && _mi != 0) {
                        modifier = val.substring(_mi + 1);
                        val = val.substring(0, _mi);
                    }
                    StringBuffer _sbvalue = new StringBuffer();
                    try {
                        int piv;
                        String ss;
                        if (val.equals("auth")) {
                            _sbvalue.append(LabelPatternUtil.firstAuthor(_entry.getField("author").toString()));
                        } else if (val.equals("edtr")) {
                            _sbvalue.append(LabelPatternUtil.firstAuthor(_entry.getField("editor").toString()));
                        } else if (val.equals("authors")) {
                            _sbvalue.append(LabelPatternUtil.allAuthors(_entry.getField("author").toString()));
                        } else if (val.equals("editors")) {
                            _sbvalue.append(LabelPatternUtil.allAuthors(_entry.getField("editor").toString()));
                        } else if (val.equals("authorIni")) {
                            _sbvalue.append(LabelPatternUtil.oneAuthorPlusIni(_entry.getField("author").toString()));
                        } else if (val.equals("editorIni")) {
                            _sbvalue.append(LabelPatternUtil.oneAuthorPlusIni(_entry.getField("editor").toString()));
                        } else if (val.equals("firstpage")) {
                            _sbvalue.append(LabelPatternUtil.firstPage(_entry.getField("pages").toString()));
                        } else if (val.equals("lastpage")) {
                            _sbvalue.append(LabelPatternUtil.lastPage(_entry.getField("pages").toString()));
                        } else if (val.equals("shorttitle")) {
                            ss = _entry.getField("title").toString();
                            int wrd = 0;
                            for (piv = 0; piv < ss.length() && wrd < 3; ++piv) {
                                if (Character.isWhitespace(ss.charAt(piv))) {
                                    ++wrd;
                                    continue;
                                }
                                _sbvalue.append(ss.charAt(piv));
                            }
                        } else if (val.equals("shortyear")) {
                            ss = _entry.getField("year").toString();
                            if (ss.length() > 2) {
                                _sbvalue.append(ss.substring(ss.length() - 2));
                            } else {
                                _sbvalue.append(ss);
                            }
                        } else if (val.equals("veryshorttitle")) {
                            ss = _entry.getField("title").toString();
                            piv = 0;
                            String[] skipWords = new String[]{"a", "an", "the"};
                            for (int _i = 0; _i < skipWords.length; ++_i) {
                                if (!ss.toLowerCase().startsWith(skipWords[_i] + " ")) continue;
                                piv = skipWords[_i].length() + 1;
                            }
                            while (piv < ss.length() && Character.isWhitespace(ss.charAt(piv))) {
                                ++piv;
                            }
                            while (piv < ss.length() && !Character.isWhitespace(ss.charAt(piv))) {
                                _sbvalue.append(ss.charAt(piv));
                                ++piv;
                            }
                        } else {
                            _sbvalue.append(_entry.getField(val).toString());
                        }
                    }
                    catch (Exception ex) {
                        Globals.logger("Key generator warning: field '" + val + "' empty.");
                    }
                    if (modifier != null) {
                        if (modifier.equals("lower")) {
                            _sb.append(_sbvalue.toString().toLowerCase());
                            continue;
                        }
                        Globals.logger("Key generator warning: unknown modifier '" + modifier + "'.");
                        continue;
                    }
                    _sb.append(_sbvalue);
                    continue;
                }
                _sb.append(val);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        String _label = Util.checkLegalKey(_sb.toString());
        if (forceUpper) {
            _label = _label.toUpperCase();
        }
        if (forceLower) {
            _label = _label.toLowerCase();
        }
        if (_db.setCiteKeyForEntry(_entry.getId(), _label)) {
            char c = 'b';
            String modKey = _label + "a";
            while (_db.setCiteKeyForEntry(_entry.getId(), modKey)) {
                char c2 = c;
                c = (char)(c + 1);
                modKey = _label + c2;
            }
        }
        return _entry;
    }

    public static String makeLabelUnique(String label) {
        String _orgLabel = label;
        String _newLabel = label;
        int lettersSize = letters.size();
        for (int i = 0; i < lettersSize && !LabelPatternUtil.isLabelUnique(_newLabel); ++i) {
            _newLabel = _orgLabel + letters.get(i).toString();
        }
        return _newLabel;
    }

    public static boolean isLabelUnique(String label) {
        boolean _isUnique = true;
        int _dbSize = _db.getEntryCount();
        for (int i = 0; i < _dbSize; ++i) {
            BibtexEntry _entry = _db.getEntryById(String.valueOf(i));
            if (!_entry.getField("bibtexkey").equals(label)) continue;
            _isUnique = false;
            break;
        }
        return _isUnique;
    }

    private static String firstAuthor(String authorField) {
        String author = "";
        String[] tokens = authorField.split("\\band\\b");
        if (tokens.length > 0) {
            if (tokens[0].indexOf(",") > 0) {
                tokens[0] = ImportFormatReader.fixAuthor(tokens[0]);
            }
            String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").split(" ");
            author = author + firstAuthor[firstAuthor.length - 1];
        }
        return author;
    }

    private static String allAuthors(String authorField) {
        String author = "";
        String[] tokens = authorField.split("\\band\\b");
        for (int i = 0; tokens.length > i; ++i) {
            if (tokens[i].indexOf(",") > 0) {
                tokens[i] = ImportFormatReader.fixAuthor(tokens[i]);
            }
            String[] firstAuthor = tokens[i].replaceAll("\\s+", " ").split(" ");
            author = author + firstAuthor[firstAuthor.length - 1];
        }
        return author;
    }

    private static String oneAuthorPlusIni(String authorField) {
        int CHARS_OF_FIRST = 5;
        authorField = ImportFormatReader.fixAuthor_lastnameFirst(authorField);
        String author = "";
        String[] tokens = authorField.split("\\band\\b");
        if (tokens.length == 0) {
            return author;
        }
        String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").split(" ");
        author = firstAuthor[0].substring(0, Math.min(5, firstAuthor[0].length()));
        for (int i = 1; tokens.length > i; ++i) {
            author = author + tokens[i].trim().charAt(0);
        }
        return author;
    }

    private static String firstPage(String pages) {
        String[] _pages = pages.split("-");
        return _pages[0];
    }

    private static String lastPage(String pages) {
        String[] _pages = pages.split("-");
        return _pages[1];
    }

    private static ArrayList builtLetters() {
        ArrayList<String> _letters = new ArrayList<String>();
        _letters.add("a");
        _letters.add("b");
        _letters.add("c");
        _letters.add("d");
        _letters.add("e");
        _letters.add("f");
        _letters.add("g");
        _letters.add("h");
        _letters.add("i");
        _letters.add("j");
        _letters.add("k");
        _letters.add("l");
        _letters.add("m");
        _letters.add("n");
        _letters.add("o");
        _letters.add("p");
        _letters.add("q");
        _letters.add("r");
        _letters.add("s");
        _letters.add("t");
        _letters.add("u");
        _letters.add("v");
        _letters.add("x");
        _letters.add("y");
        _letters.add("z");
        return _letters;
    }
}

