/*
 * Decompiled with CFR 0.152.
 */
package jabref.imports;

import jabref.BibtexEntry;
import jabref.Globals;
import jabref.Util;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MedlineHandler
extends DefaultHandler {
    ArrayList bibitems = new ArrayList();
    boolean inTitle = false;
    boolean inYear = false;
    boolean inJournal = false;
    boolean inMonth = false;
    boolean inVolume = false;
    boolean inAuthorList = false;
    boolean inAuthor = false;
    boolean inLastName = false;
    boolean inInitials = false;
    boolean inMedlinePgn = false;
    boolean inMedlineID = false;
    boolean inURL = false;
    boolean inIssue = false;
    boolean inPubDate = false;
    boolean inUrl = false;
    boolean inForename = false;
    boolean inAbstractText = false;
    boolean inMedlineDate = false;
    boolean inPubMedID = false;
    boolean inDescriptorName = false;
    boolean inDoi = false;
    boolean inPii = false;
    String title = "";
    String journal = "";
    String keyword = "";
    String author = "";
    String lastName = "";
    String year = "";
    String forename = "";
    String abstractText = "";
    String month = "";
    String volume = "";
    String lastname = "";
    String initials = "";
    String number = "";
    String page = "";
    String medlineID = "";
    String url = "";
    String MedlineDate = "";
    String series = "";
    String editor = "";
    String booktitle = "";
    String type = "article";
    String key = "";
    String address = "";
    String pubmedid = "";
    String descriptorName = "";
    String doi = "";
    String pii = "";
    ArrayList authors = new ArrayList();
    int rowNum = 0;

    public ArrayList getItems() {
        return this.bibitems;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!localName.equals("PubmedArticle")) {
            if (localName.equals("ArticleTitle")) {
                this.inTitle = true;
                this.title = "";
            } else if (localName.equals("PubDate")) {
                this.inPubDate = true;
            } else if (localName.equals("Year") && this.inPubDate) {
                this.inYear = true;
            } else if (localName.equals("MedlineDate") && this.inPubDate) {
                this.inMedlineDate = true;
            } else if (localName.equals("MedlineTA")) {
                this.inJournal = true;
                this.journal = "";
            } else if (localName.equals("Month") && this.inPubDate) {
                this.inMonth = true;
            } else if (localName.equals("Volume")) {
                this.inVolume = true;
            } else if (localName.equals("AuthorList")) {
                this.inAuthorList = true;
                this.authors.clear();
            } else if (localName.equals("DescriptorName")) {
                this.inDescriptorName = true;
            } else if (localName.equals("Author")) {
                this.inAuthor = true;
                this.author = "";
            } else if (localName.equals("PMID")) {
                this.inPubMedID = true;
                this.pubmedid = "";
            } else if (localName.equals("LastName")) {
                this.inLastName = true;
                this.lastName = "";
            } else if (localName.equals("ForeName") || localName.equals("FirstName")) {
                this.inForename = true;
                this.forename = "";
            } else if (localName.equals("Issue")) {
                this.inIssue = true;
            } else if (localName.equals("MedlinePgn")) {
                this.inMedlinePgn = true;
            } else if (localName.equals("URL")) {
                this.inUrl = true;
            } else if (localName.equals("Initials")) {
                this.inInitials = true;
            } else if (localName.equals("AbstractText")) {
                this.inAbstractText = true;
            } else if (localName.equals("ArticleId")) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String name = atts.getQName(i);
                    String type = atts.getType(i);
                    String value = atts.getValue(i);
                    if (value.equals("doi")) {
                        this.inDoi = true;
                        continue;
                    }
                    if (!value.equals("pii")) continue;
                    this.inPii = true;
                }
            }
        }
    }

    String join(Object[] sa, String delim) {
        StringBuffer sb = new StringBuffer();
        sb.append(sa[0].toString());
        for (int i = 1; i < sa.length; ++i) {
            sb.append(delim);
            sb.append(sa[i].toString());
        }
        return sb.toString();
    }

    String makeBibtexString() {
        String out = "";
        out = "article{,\n author = { " + this.author + " },\n title = { " + this.title + "},\n journal ={ " + this.journal + "},\n year = " + this.year + "},\n volume = { " + this.volume + "},\n number = { " + this.number + "},\n pages = { " + this.page + "},\n abstract = { " + this.abstractText + "},\n}";
        return out;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("PubmedArticle")) {
            if (this.year.equals("") && !this.MedlineDate.equals("")) {
                this.year = this.MedlineDate.substring(0, 4);
            }
            this.title = Globals.putBracesAroundCapitals(this.title);
            this.keyword = this.descriptorName + this.pubmedid;
            BibtexEntry b = new BibtexEntry(Util.createNeutralId(), Globals.getEntryType("article"));
            if (!this.author.equals("")) {
                b.setField("author", this.author);
            }
            if (!this.title.equals("")) {
                b.setField("title", this.title);
            }
            if (!this.journal.equals("")) {
                b.setField("journal", this.journal);
            }
            if (!this.year.equals("")) {
                b.setField("year", this.year);
            }
            if (!this.page.equals("")) {
                b.setField("pages", this.page);
            }
            if (!this.volume.equals("")) {
                b.setField("volume", this.volume);
            }
            if (!this.abstractText.equals("")) {
                b.setField("abstract", this.abstractText.replaceAll("%", "\\\\%"));
            }
            if (!this.keyword.equals("")) {
                b.setField("keywords", this.keyword);
            }
            if (!this.month.equals("")) {
                b.setField("month", this.month);
            }
            if (!this.number.equals("")) {
                b.setField("number", this.number);
            }
            if (!this.doi.equals("")) {
                b.setField("doi", this.doi);
                b.setField("url", "http://dx.doi.org/" + this.doi);
            }
            if (!this.pii.equals("")) {
                b.setField("pii", this.pii);
            }
            this.bibitems.add(b);
            this.abstractText = "";
            this.author = "";
            this.title = "";
            this.journal = "";
            this.keyword = "";
            this.doi = "";
            this.pii = "";
            this.year = "";
            this.forename = "";
            this.abstractText = "";
            this.pubmedid = "";
            this.month = "";
            this.volume = "";
            this.lastname = "";
            this.initials = "";
            this.number = "";
            this.page = "";
            this.medlineID = "";
            this.url = "";
            this.MedlineDate = "";
        } else if (localName.equals("ArticleTitle")) {
            this.inTitle = false;
        } else if (localName.equals("PubDate")) {
            this.inPubDate = false;
        } else if (localName.equals("Year")) {
            this.inYear = false;
        } else if (localName.equals("PMID")) {
            this.inPubMedID = false;
        } else if (localName.equals("MedlineDate")) {
            this.inMedlineDate = false;
        } else if (localName.equals("MedlineTA")) {
            this.inJournal = false;
        } else if (localName.equals("Month")) {
            this.inMonth = false;
        } else if (localName.equals("Volume")) {
            this.inVolume = false;
        } else if (localName.equals("AuthorList")) {
            this.author = this.join(this.authors.toArray(), " and ");
            this.inAuthorList = false;
        } else if (localName.equals("Author")) {
            if (this.forename.length() == 3 && this.forename.charAt(1) == ' ') {
                this.forename = this.initials;
            }
            this.author = this.forename + " " + this.lastname;
            this.authors.add(this.author);
            this.inAuthor = false;
        } else if (localName.equals("DescriptorName")) {
            this.inDescriptorName = false;
        } else if (localName.equals("LastName")) {
            this.inLastName = false;
        } else if (localName.equals("ForeName") || localName.equals("FirstName")) {
            this.inForename = false;
        } else if (localName.equals("Issue")) {
            this.inIssue = false;
        } else if (localName.equals("MedlinePgn")) {
            this.inMedlinePgn = false;
        } else if (localName.equals("URL")) {
            this.inUrl = false;
        } else if (localName.equals("Initials")) {
            this.inInitials = false;
        } else if (localName.equals("AbstractText")) {
            this.inAbstractText = false;
        } else if (localName.equals("ArticleId")) {
            if (this.inDoi) {
                this.inDoi = false;
            } else if (this.inPii) {
                this.inPii = false;
            }
        }
    }

    @Override
    public void characters(char[] data, int start, int length) {
        if (this.inTitle) {
            this.title = new String(data, start, length);
        } else if (this.inYear) {
            this.year = new String(data, start, length);
        } else if (this.inJournal) {
            this.journal = new String(data, start, length);
        } else if (this.inMonth) {
            this.month = new String(data, start, length);
        } else if (this.inVolume) {
            this.volume = new String(data, start, length);
        } else if (this.inLastName) {
            this.lastname = new String(data, start, length);
        } else if (this.inInitials) {
            this.initials = new String(data, start, length);
        } else if (this.inIssue) {
            this.number = new String(data, start, length);
        } else if (this.inMedlinePgn) {
            this.page = new String(data, start, length);
        } else if (this.inMedlineID) {
            this.medlineID = new String(data, start, length);
        } else if (this.inURL) {
            this.url = new String(data, start, length);
        } else if (this.inPubMedID) {
            this.pubmedid = new String(data, start, length);
        } else if (this.inDescriptorName) {
            this.descriptorName = this.descriptorName + new String(data, start, length) + ", ";
        } else if (this.inForename) {
            this.forename = new String(data, start, length);
        } else if (this.inAbstractText) {
            this.abstractText = this.abstractText + new String(data, start, length);
        } else if (this.inMedlineDate) {
            this.MedlineDate = this.MedlineDate + new String(data, start, length);
        } else if (this.inDoi) {
            this.doi = new String(data, start, length);
        } else if (this.inPii) {
            this.pii = new String(data, start, length);
        }
    }
}

