/*
 * Decompiled with CFR 0.152.
 */
package jabref.imports;

import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.Globals;
import jabref.Util;
import jabref.imports.BibTeXMLHandler;
import jabref.imports.MedlineHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportFormatReader {
    public static Pattern ovid_src_pat = Pattern.compile("Source ([ \\w&\\-]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    public static Pattern ovid_src_pat_no_issue = Pattern.compile("Source ([ \\w&\\-]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");

    public static String fixAuthor_nocomma(String in) {
        StringBuffer sb = new StringBuffer();
        String[] authors = in.split(" and ");
        for (int i = 0; i < authors.length; ++i) {
            authors[i] = authors[i].trim();
            String[] t = authors[i].split(" ");
            sb.append(t[1].trim() + " " + t[0].trim());
            if (i == authors.length - 1) {
                sb.append(".");
                continue;
            }
            sb.append(" and ");
        }
        return sb.toString();
    }

    public static String fixAuthor(String in) {
        StringBuffer sb = new StringBuffer();
        String[] authors = in.split(" and ");
        for (int i = 0; i < authors.length; ++i) {
            String[] t = authors[i].split(",");
            if (t.length < 2) {
                return in;
            }
            sb.append(t[1].trim() + " " + t[0].trim());
            if (i == authors.length - 1) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }

    public static String fixAuthor_lastnameFirst(String in) {
        StringBuffer sb = new StringBuffer();
        String[] authors = in.split(" and ");
        for (int i = 0; i < authors.length; ++i) {
            String[] t = authors[i].split(",");
            if (t.length < 2) {
                t = authors[i].split(" ");
                if (t.length > 1) {
                    sb.append(t[t.length - 1] + ",");
                    for (int j = 0; j < t.length - 1; ++j) {
                        sb.append(" " + t[j]);
                    }
                } else {
                    sb.append(t[0]);
                }
            } else {
                sb.append(authors[i]);
            }
            if (i == authors.length - 1) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }

    public static ArrayList readSixpack(String filename) {
        String SEPARATOR = new String(new char[]{'\u0000', '0'});
        HashMap<String, String> fI = new HashMap<String, String>();
        fI.put("id", "bibtexkey");
        fI.put("au", "author");
        fI.put("ti", "title");
        fI.put("jo", "journal");
        fI.put("vo", "volume");
        fI.put("nu", "number");
        fI.put("pa", "pages");
        fI.put("mo", "month");
        fI.put("yr", "year");
        fI.put("kw", "keywords");
        fI.put("ab", "abstract");
        fI.put("no", "note");
        fI.put("ed", "editor");
        fI.put("pu", "publisher");
        fI.put("se", "series");
        fI.put("ad", "address");
        fI.put("en", "edition");
        fI.put("ch", "chapter");
        fI.put("hp", "howpublished");
        fI.put("tb", "booktitle");
        fI.put("or", "organization");
        fI.put("sc", "school");
        fI.put("in", "institution");
        fI.put("ty", "type");
        fI.put("url", "url");
        fI.put("cr", "crossref");
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            in.readLine();
            String[] fieldDef = in.readLine().split(",");
            String s = null;
            BibtexEntry entry = null;
            while ((s = in.readLine()) != null) {
                try {
                    s = s.replaceAll("<par>", "");
                    String[] fields = s.split(SEPARATOR);
                    BibtexEntryType typ = BibtexEntryType.getType(fields[1].toLowerCase());
                    if (typ == null) {
                        String type = "";
                        if (fields[1].equals("Masterthesis")) {
                            type = "mastersthesis";
                        }
                        if (fields[1].equals("PhD-Thesis")) {
                            type = "phdthesis";
                        }
                        if (fields[1].equals("miscellaneous")) {
                            type = "misc";
                        }
                        if (fields[1].equals("Conference")) {
                            type = "proceedings";
                        }
                        typ = BibtexEntryType.getType(type.toLowerCase());
                    }
                    entry = new BibtexEntry(Util.createNeutralId(), typ);
                    for (int i = 0; i < Math.min(fieldDef.length, fields.length); ++i) {
                        String fld = (String)fI.get(fieldDef[i]);
                        if (fld == null) continue;
                        if (fld.equals("author") || fld.equals("editor")) {
                            ImportFormatReader.setField(entry, fld, fields[i].replaceAll(" and ", ", ").replaceAll(", ", " and "));
                            continue;
                        }
                        if (fld.equals("pages")) {
                            ImportFormatReader.setField(entry, fld, fields[i].replaceAll("-", "--"));
                            continue;
                        }
                        ImportFormatReader.setField(entry, fld, fields[i]);
                    }
                    bibitems.add(entry);
                }
                catch (NullPointerException ex) {
                    Globals.logger("Problem parsing Sixpack entry, ignoring entry.");
                }
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return bibitems;
    }

    private static void setField(BibtexEntry be, String field, String content) {
        if (!content.equals("")) {
            be.setField(field, content);
        }
    }

    public static ArrayList readScifinder(String filename) {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        String[] entries = sb.toString().split("START_RECORD");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 1; i < entries.length; ++i) {
            String[] fields = entries[i].split("FIELD ");
            String Type2 = "";
            hm.clear();
            for (int j = 0; j < fields.length; ++j) {
                String[] tmp = fields[j].split(":");
                if (tmp.length <= 1) continue;
                if (tmp[0].equals("Author")) {
                    hm.put("author", tmp[1].replaceAll(";", " and "));
                    continue;
                }
                if (tmp[0].equals("Title")) {
                    hm.put("title", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Journal Title")) {
                    hm.put("journal", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Volume")) {
                    hm.put("volume", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Page")) {
                    hm.put("pages", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Publication Year")) {
                    hm.put("year", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Abstract")) {
                    hm.put("abstract", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Supplementary Terms")) {
                    hm.put("keywords", tmp[1]);
                    continue;
                }
                if (!tmp[0].equals("Document Type")) continue;
                Type2 = tmp[1].replaceAll("Journal", "article");
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            bibitems.add(b);
        }
        return bibitems;
    }

    public static ArrayList readISI(String filename) {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((str = in.readLine()) != null) {
                if (str.length() < 3) continue;
                if (str.substring(0, 3).equals("PT ")) {
                    sb.append("::" + str);
                    continue;
                }
                String beg = str.substring(0, 3).trim();
                if (beg.length() == 2) {
                    sb.append(" ## ");
                    sb.append(str);
                    continue;
                }
                sb.append("EOLEOL");
                sb.append(str.substring(2, str.length()));
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println("Error reading file: " + filename);
            return null;
        }
        String[] entries = sb.toString().split("::");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 1; i < entries.length; ++i) {
            String[] fields = entries[i].split(" ## ");
            String Type2 = "";
            String PT = "";
            String pages = "";
            hm.clear();
            for (int j = 0; j < fields.length; ++j) {
                String beg = fields[j].substring(0, 2);
                if (beg.equals("PT")) {
                    PT = fields[j].substring(2, fields[j].length()).trim().replaceAll("Journal", "article");
                    Type2 = "article";
                    continue;
                }
                if (beg.equals("AU")) {
                    hm.put("author", ImportFormatReader.fixAuthor(fields[j].substring(2, fields[j].length()).trim().replaceAll("EOLEOL", " and ")));
                    continue;
                }
                if (beg.equals("TI")) {
                    hm.put("title", fields[j].substring(2, fields[j].length()).trim().replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("SO")) {
                    hm.put("journal", fields[j].substring(2, fields[j].length()).trim());
                    continue;
                }
                if (beg.equals("ID")) {
                    hm.put("keywords", fields[j].substring(2, fields[j].length()).trim().replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("AB")) {
                    hm.put("abstract", fields[j].substring(2, fields[j].length()).trim().replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("BP")) {
                    pages = fields[j].substring(2, fields[j].length()).trim();
                    continue;
                }
                if (beg.equals("EP")) {
                    pages = pages + "--" + fields[j].substring(2, fields[j].length()).trim();
                    continue;
                }
                if (beg.equals("IS")) {
                    hm.put("number", fields[j].substring(2, fields[j].length()).trim());
                    continue;
                }
                if (beg.equals("PY")) {
                    hm.put("year", fields[j].substring(2, fields[j].length()).trim());
                    continue;
                }
                if (beg.equals("VL")) {
                    hm.put("volume", fields[j].substring(2, fields[j].length()).trim());
                    continue;
                }
                if (beg.equals("DT")) {
                    Type2 = fields[j].substring(2, fields[j].length()).trim();
                    if (!Type2.equals("Article") && !PT.equals("Journal")) {
                        Type2 = "misc";
                        continue;
                    }
                    Type2 = "article";
                    continue;
                }
                if (!beg.equals("CR")) continue;
                hm.put("CitedReferences", fields[j].substring(2, fields[j].length()).replaceAll("EOLEOL", " ; ").trim());
            }
            hm.put("pages", pages);
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            bibitems.add(b);
        }
        return bibitems;
    }

    public static ArrayList readOvid(String filename) {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        boolean rowNum = false;
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error: " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) != ' ') {
                    sb.append("__NEWFIELD__");
                }
                sb.append(line);
            }
            in.close();
            String[] items = sb.toString().split("<[0-9]+>");
            for (int i = 1; i < items.length; ++i) {
                HashMap<String, String> h = new HashMap<String, String>();
                String[] fields = items[i].split("__NEWFIELD__");
                for (int j = 0; j < fields.length; ++j) {
                    fields[j] = fields[j].trim();
                    if (fields[j].indexOf("Author") == 0 && fields[j].indexOf("Author Keywords") == -1 && fields[j].indexOf("Author e-mail") == -1) {
                        String author;
                        boolean isComma = false;
                        if (fields[j].indexOf(";") > 0) {
                            author = fields[j].substring(7, fields[j].length()).replaceAll("[^\\.A-Za-z,;\\- ]", "").replaceAll(";", " and ");
                        } else {
                            isComma = true;
                            author = fields[j].substring(7, fields[j].length()).replaceAll("\\.", " and").replaceAll(" and$", "");
                        }
                        if (author.split(" and ").length > 1) {
                            if (!isComma) {
                                h.put("author", ImportFormatReader.fixAuthor(author));
                                continue;
                            }
                            h.put("author", ImportFormatReader.fixAuthor_nocomma(author));
                            continue;
                        }
                        h.put("author", author);
                        continue;
                    }
                    if (fields[j].indexOf("Title") == 0) {
                        h.put("title", fields[j].substring(6, fields[j].length()).replaceAll("\\[.+\\]", ""));
                        continue;
                    }
                    if (fields[j].indexOf("Source") == 0) {
                        String s = fields[j];
                        Matcher matcher = ovid_src_pat.matcher(s);
                        boolean matchfound = matcher.find();
                        if (matchfound) {
                            h.put("journal", matcher.group(1));
                            h.put("volume", matcher.group(2));
                            h.put("issue", matcher.group(3));
                            h.put("pages", matcher.group(4));
                            h.put("year", matcher.group(5));
                            continue;
                        }
                        matcher = ovid_src_pat_no_issue.matcher(s);
                        matchfound = matcher.find();
                        if (!matchfound) continue;
                        h.put("journal", matcher.group(1));
                        h.put("volume", matcher.group(2));
                        h.put("pages", matcher.group(3));
                        h.put("year", matcher.group(4));
                        continue;
                    }
                    if (fields[j].indexOf("Abstract") != 0) continue;
                    h.put("abstract", fields[j].substring(9, fields[j].length()));
                }
                BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType("article"));
                b.setField(h);
                bibitems.add(b);
            }
        }
        catch (IOException ex) {
            return null;
        }
        return bibitems;
    }

    static File checkAndCreateFile(String filename) {
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            Globals.logger("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        return f;
    }

    public static ArrayList readEndnote(String filename) {
        String ENDOFRECORD = "__EOREOR__";
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = ImportFormatReader.checkAndCreateFile(filename);
        if (f == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            boolean first = true;
            while ((str = in.readLine()) != null) {
                if ((str = str.trim()).indexOf("%0") == 0) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(ENDOFRECORD);
                    }
                    sb.append(str);
                } else {
                    sb.append(str);
                }
                sb.append("\n");
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        String[] entries = sb.toString().split(ENDOFRECORD);
        HashMap<String, String> hm = new HashMap<String, String>();
        String Author = "";
        String Type2 = "";
        String Editor2 = "";
        for (int i = 0; i < entries.length; ++i) {
            hm.clear();
            Author = "";
            Type2 = "";
            Editor2 = "";
            String[] fields = entries[i].substring(1).split("\n%");
            for (int j = 0; j < fields.length; ++j) {
                if (fields[j].length() < 3) continue;
                String prefix = fields[j].substring(0, 1);
                String val = fields[j].substring(2);
                if (prefix.equals("A")) {
                    if (Author.equals("")) {
                        Author = val;
                        continue;
                    }
                    Author = Author + " and " + val;
                    continue;
                }
                if (prefix.equals("Y")) {
                    if (Editor2.equals("")) {
                        Editor2 = val;
                        continue;
                    }
                    Editor2 = Editor2 + " and " + val;
                    continue;
                }
                if (prefix.equals("T")) {
                    hm.put("title", Globals.putBracesAroundCapitals(val));
                    continue;
                }
                if (prefix.equals("0")) {
                    if (val.indexOf("Journal") == 0) {
                        Type2 = "article";
                        continue;
                    }
                    if (val.indexOf("Book") == 0 || val.indexOf("Edited Book") == 0) {
                        Type2 = "book";
                        continue;
                    }
                    if (val.indexOf("Conference") == 0) {
                        Type2 = "inproceedings";
                        continue;
                    }
                    if (val.indexOf("Report") == 0) {
                        Type2 = "techreport";
                        continue;
                    }
                    Type2 = "misc";
                    continue;
                }
                if (prefix.equals("7")) {
                    hm.put("edition", val);
                    continue;
                }
                if (prefix.equals("C")) {
                    hm.put("address", val);
                    continue;
                }
                if (prefix.equals("D")) {
                    hm.put("year", val);
                    continue;
                }
                if (prefix.equals("8")) {
                    hm.put("date", val);
                    continue;
                }
                if (prefix.equals("J")) {
                    if (hm.get("journal") != null) continue;
                    hm.put("journal", val);
                    continue;
                }
                if (prefix.equals("B")) {
                    if (Type2.equals("article")) {
                        hm.put("journal", val);
                        continue;
                    }
                    if (Type2.equals("book") || Type2.equals("inbook")) {
                        hm.put("series", val);
                        continue;
                    }
                    hm.put("booktitle", val);
                    continue;
                }
                if (prefix.equals("I")) {
                    hm.put("publisher", val);
                    continue;
                }
                if (prefix.equals("P")) {
                    hm.put("pages", val);
                    continue;
                }
                if (prefix.equals("V")) {
                    hm.put("volume", val);
                    continue;
                }
                if (prefix.equals("N")) {
                    hm.put("number", val);
                    continue;
                }
                if (prefix.equals("U")) {
                    hm.put("url", val);
                    continue;
                }
                if (prefix.equals("O")) {
                    hm.put("note", val);
                    continue;
                }
                if (prefix.equals("K")) {
                    hm.put("keywords", val);
                    continue;
                }
                if (prefix.equals("X")) {
                    hm.put("abstract", val);
                    continue;
                }
                if (prefix.equals("9")) {
                    if (val.indexOf("Ph.D.") != 0) continue;
                    Type2 = "phdthesis";
                    continue;
                }
                if (!prefix.equals("F")) continue;
                hm.put("bibtexkey", Util.checkLegalKey(val));
            }
            if (!Author.equals("")) {
                hm.put("author", ImportFormatReader.fixAuthor(Author));
            }
            if (!Editor2.equals("")) {
                hm.put("editor", ImportFormatReader.fixAuthor(Editor2));
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            if (b.getAllFields().length <= 0) continue;
            bibitems.add(b);
        }
        return bibitems;
    }

    public static ArrayList readReferenceManager10(String filename) {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((str = in.readLine()) != null) {
                sb.append(str);
                sb.append("\n");
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        String[] entries = sb.toString().split("ER  -");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 0; i < entries.length - 1; ++i) {
            String Type2 = "";
            String Author = "";
            String StartPage = "";
            String EndPage = "";
            hm.clear();
            String[] fields = entries[i].split("\n");
            for (int j = 0; j < fields.length; ++j) {
                if (fields[j].length() < 2) continue;
                String lab = fields[j].substring(0, 2);
                String val = fields[j].substring(6).trim();
                if (lab.equals("TY")) {
                    if (val.equals("BOOK")) {
                        Type2 = "book";
                        continue;
                    }
                    if (val.equals("JOUR")) {
                        Type2 = "article";
                        continue;
                    }
                    Type2 = "other";
                    continue;
                }
                if (lab.equals("T1")) {
                    hm.put("title", val);
                    continue;
                }
                if (lab.equals("A1") || lab.equals("AU")) {
                    if (Author.equals("")) {
                        Author = val;
                        continue;
                    }
                    Author = Author + " and " + val;
                    continue;
                }
                if (lab.equals("JA") || lab.equals("JF") || lab.equals("JO")) {
                    hm.put("journal", val);
                    continue;
                }
                if (lab.equals("SP")) {
                    StartPage = val;
                    continue;
                }
                if (lab.equals("EP")) {
                    EndPage = val;
                    continue;
                }
                if (lab.equals("VL")) {
                    hm.put("volume", val);
                    continue;
                }
                if (lab.equals("IS")) {
                    hm.put("number", val);
                    continue;
                }
                if (lab.equals("N2") || lab.equals("AB")) {
                    hm.put("abstract", val);
                    continue;
                }
                if (lab.equals("UR")) {
                    hm.put("url", val);
                    continue;
                }
                if (!lab.equals("Y1") && !lab.equals("PY") || val.length() < 4) continue;
                hm.put("year", val.substring(0, 4));
            }
            if ((Author = ImportFormatReader.fixAuthor(Author)).endsWith(".")) {
                hm.put("author", Author.substring(0, Author.length() - 1));
            } else {
                hm.put("author", Author);
            }
            hm.put("pages", StartPage + "--" + EndPage);
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            bibitems.add(b);
        }
        return bibitems;
    }

    public static ArrayList readMedline(String filename) {
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(true);
        parserFactory.setNamespaceAware(true);
        ArrayList bibItems = null;
        try {
            SAXParser parser = parserFactory.newSAXParser();
            MedlineHandler handler = new MedlineHandler();
            parser.parse(new File(filename), (DefaultHandler)handler);
            bibItems = handler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bibItems;
    }

    public static ArrayList readBibTeXML(String filename) {
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(true);
        parserFactory.setNamespaceAware(true);
        ArrayList bibItems = null;
        try {
            SAXParser parser = parserFactory.newSAXParser();
            BibTeXMLHandler handler = new BibTeXMLHandler();
            parser.parse(new File(filename), (DefaultHandler)handler);
            bibItems = handler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bibItems;
    }

    public static ArrayList fetchMedline(String id) {
        ArrayList bibItems = null;
        try {
            String baseUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=" + id;
            URL url = new URL(baseUrl);
            HttpURLConnection data = (HttpURLConnection)url.openConnection();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            MedlineHandler handler = new MedlineHandler();
            parser.parse(data.getInputStream(), (DefaultHandler)handler);
            bibItems = handler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bibItems;
    }

    public static ArrayList readINSPEC(String filename) {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((str = in.readLine()) != null) {
                if (str.length() < 2) continue;
                if (str.indexOf("Record") == 0) {
                    sb.append("__::__" + str);
                    continue;
                }
                sb.append("__NEWFIELD__" + str);
            }
            in.close();
            String[] entries = sb.toString().split("__::__");
            String Type2 = "";
            HashMap<String, String> h = new HashMap<String, String>();
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].indexOf("Record") != 0) continue;
                h.clear();
                String[] fields = entries[i].split("__NEWFIELD__");
                for (int j = 0; j < fields.length; ++j) {
                    String s = fields[j];
                    String f3 = s.substring(0, 2);
                    String frest = s.substring(5);
                    if (f3.equals("TI")) {
                        h.put("title", frest);
                        continue;
                    }
                    if (f3.equals("PY")) {
                        h.put("year", frest);
                        continue;
                    }
                    if (f3.equals("AU")) {
                        h.put("author", ImportFormatReader.fixAuthor(frest.replaceAll(",-", ", ").replaceAll(";", " and ")));
                        continue;
                    }
                    if (f3.equals("AB")) {
                        h.put("abstract", frest);
                        continue;
                    }
                    if (f3.equals("ID")) {
                        h.put("keywords", frest);
                        continue;
                    }
                    if (f3.equals("SO")) {
                        int m = frest.indexOf(".");
                        if (m < 0) continue;
                        String jr = frest.substring(0, m);
                        h.put("journal", jr.replaceAll("-", " "));
                        frest = frest.substring(m);
                        m = frest.indexOf(";");
                        if (m < 5) continue;
                        String yr = frest.substring(m - 5, m);
                        h.put("year", yr);
                        frest = frest.substring(m);
                        m = frest.indexOf(":");
                        if (m < 0) continue;
                        String pg = frest.substring(m + 1).trim();
                        h.put("pages", pg);
                        h.put("volume", frest.substring(1, m));
                        continue;
                    }
                    if (!f3.equals("RT")) continue;
                    Type2 = (frest = frest.trim()).equals("Journal-Paper") ? "article" : (frest.equals("Conference-Paper") || frest.equals("Conference-Paper; Journal-Paper") ? "inproceedings" : frest.replaceAll(" ", ""));
                }
                BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
                b.setField(h);
                bibitems.add(b);
            }
        }
        catch (IOException e) {
            return null;
        }
        return bibitems;
    }

    public static ArrayList readBiblioscapeTagFile(String filename) {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        File f = new File(filename);
        if (!(f.exists() && f.canRead() && f.isFile())) {
            System.err.println("Error: " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            HashMap<String, String> hm = new HashMap<String, String>();
            HashMap<String, StringBuffer> lines = new HashMap<String, StringBuffer>();
            StringBuffer previousLine = null;
            while ((line = in.readLine()) != null) {
                if (line.equals("------")) {
                    String[] type = new String[2];
                    String[] pages = new String[2];
                    String country = null;
                    String address = null;
                    Vector<String> comments = new Vector<String>();
                    Object[] l = lines.entrySet().toArray();
                    for (int i = 0; i < l.length; ++i) {
                        Map.Entry entry = (Map.Entry)l[i];
                        if (entry.getKey().equals("AU")) {
                            hm.put("author", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("TI")) {
                            hm.put("title", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("ST")) {
                            hm.put("booktitle", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("YP")) {
                            hm.put("year", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("VL")) {
                            hm.put("volume", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("NB")) {
                            hm.put("number", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("PS")) {
                            pages[0] = entry.getValue().toString();
                            continue;
                        }
                        if (entry.getKey().equals("PE")) {
                            pages[1] = entry.getValue().toString();
                            continue;
                        }
                        if (entry.getKey().equals("KW")) {
                            hm.put("keywords", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("RT")) {
                            type[0] = entry.getValue().toString();
                            continue;
                        }
                        if (entry.getKey().equals("SB")) {
                            comments.add("Subject: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("SA")) {
                            comments.add("Secondary Authors: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("NT")) {
                            hm.put("note", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("PB")) {
                            hm.put("publisher", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("TA")) {
                            comments.add("Tertiary Authors: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("TT")) {
                            comments.add("Tertiary Title: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("ED")) {
                            hm.put("edition", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("TW")) {
                            type[1] = entry.getValue().toString();
                            continue;
                        }
                        if (entry.getKey().equals("QA")) {
                            comments.add("Quaternary Authors: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("QT")) {
                            comments.add("Quaternary Title: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("IS")) {
                            hm.put("isbn", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("AB")) {
                            hm.put("abstract", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("AD")) {
                            address = entry.getValue().toString();
                            continue;
                        }
                        if (entry.getKey().equals("LG")) {
                            hm.put("language", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("CO")) {
                            country = entry.getValue().toString();
                            continue;
                        }
                        if (entry.getKey().equals("UR") || entry.getKey().equals("AT")) {
                            String s = entry.getValue().toString().trim();
                            hm.put(s.startsWith("http://") || s.startsWith("ftp://") ? "url" : "pdf", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("C1")) {
                            comments.add("Custom1: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("C2")) {
                            comments.add("Custom2: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("C3")) {
                            comments.add("Custom3: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("C4")) {
                            comments.add("Custom4: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("C5")) {
                            comments.add("Custom5: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("C6")) {
                            comments.add("Custom6: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("DE")) {
                            hm.put("annote", entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("CA")) {
                            comments.add("Categories: " + entry.getValue().toString());
                            continue;
                        }
                        if (entry.getKey().equals("TH")) {
                            comments.add("Short Title: " + entry.getValue().toString());
                            continue;
                        }
                        if (!entry.getKey().equals("SE")) continue;
                        hm.put("chapter", entry.getValue().toString());
                    }
                    String bibtexType = "misc";
                    if (type[1] != null) {
                        type[1] = type[1].toLowerCase();
                        if (type[1].indexOf("article") >= 0) {
                            bibtexType = "article";
                        } else if (type[1].indexOf("book") >= 0) {
                            bibtexType = "book";
                        } else if (type[1].indexOf("conference") >= 0) {
                            bibtexType = "inproceedings";
                        } else if (type[1].indexOf("proceedings") >= 0) {
                            bibtexType = "inproceedings";
                        } else if (type[1].indexOf("report") >= 0) {
                            bibtexType = "techreport";
                        } else if (type[1].indexOf("thesis") >= 0 && type[1].indexOf("master") >= 0) {
                            bibtexType = "mastersthesis";
                        } else if (type[1].indexOf("thesis") >= 0) {
                            bibtexType = "phdthesis";
                        }
                    } else if (type[0] != null) {
                        type[0] = type[0].toLowerCase();
                        if (type[0].indexOf("article") >= 0) {
                            bibtexType = "article";
                        } else if (type[0].indexOf("book") >= 0) {
                            bibtexType = "book";
                        } else if (type[0].indexOf("conference") >= 0) {
                            bibtexType = "inproceedings";
                        } else if (type[0].indexOf("proceedings") >= 0) {
                            bibtexType = "inproceedings";
                        } else if (type[0].indexOf("report") >= 0) {
                            bibtexType = "techreport";
                        } else if (type[0].indexOf("thesis") >= 0 && type[0].indexOf("master") >= 0) {
                            bibtexType = "mastersthesis";
                        } else if (type[0].indexOf("thesis") >= 0) {
                            bibtexType = "phdthesis";
                        }
                    }
                    if (pages[0] != null || pages[1] != null) {
                        hm.put("pages", (pages[0] != null ? pages[0] : "") + (pages[1] != null ? "--" + pages[1] : ""));
                    }
                    if (address != null) {
                        hm.put("address", address + (country != null ? ", " + country : ""));
                    }
                    if (comments.size() > 0) {
                        StringBuffer s = new StringBuffer();
                        for (int i = 0; i < comments.size(); ++i) {
                            s.append((i > 0 ? "; " : "") + comments.elementAt(i).toString());
                        }
                        hm.put("comment", s.toString());
                    }
                    BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(bibtexType));
                    b.setField(hm);
                    bibitems.add(b);
                    hm.clear();
                    lines.clear();
                    previousLine = null;
                    continue;
                }
                if (line.startsWith("--") && line.length() >= 7 && line.substring(4, 7).equals("-- ")) {
                    previousLine = new StringBuffer(line.substring(7));
                    lines.put(line.substring(2, 4), previousLine);
                    continue;
                }
                if (previousLine == null) {
                    return null;
                }
                previousLine.append(line.trim());
            }
        }
        catch (IOException e) {
            return null;
        }
        return bibitems;
    }
}

