/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.BibtexEntry;
import jabref.SearchRule;
import java.util.Hashtable;
import java.util.regex.Pattern;

public class QuickSearchRule
implements SearchRule {
    String field;
    Pattern pattern;

    public QuickSearchRule(String field, String searchString) {
        this.field = field.toLowerCase();
        if (!searchString.matches("\\.\\*")) {
            searchString = ".*" + searchString + ".*";
        }
        int flags = 2;
        this.pattern = Pattern.compile(searchString, flags);
    }

    @Override
    public int applyRule(Hashtable searchOptions, BibtexEntry bibtexEntry) {
        int score = 0;
        String content = (String)bibtexEntry.getField(this.field);
        if (content != null && this.pattern.matcher(content).matches()) {
            score = 1;
        }
        return score;
    }

    public void removeMatches(BibtexEntry bibtexEntry) {
        String content = (String)bibtexEntry.getField(this.field);
        StringBuffer sb = new StringBuffer();
        if (content != null) {
            String[] split = this.pattern.split(content);
            for (int i = 0; i < split.length; ++i) {
                sb.append(split[i]);
            }
        }
        bibtexEntry.setField(this.field, sb.length() > 0 ? sb.toString() : null);
    }
}

