/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.JabRefPreferences;
import jabref.SearchRule;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimpleSearchRule
implements SearchRule {
    JabRefPreferences prefs;

    public SimpleSearchRule(JabRefPreferences prefs2) {
        this.prefs = prefs2;
    }

    @Override
    public int applyRule(Hashtable searchStrings, BibtexEntry bibtexEntry) {
        int score = 0;
        boolean counter = false;
        Enumeration e = searchStrings.elements();
        String searchString = (String)e.nextElement();
        String upperString = null;
        try {
            upperString = searchString.substring(0, 1).toUpperCase() + searchString.substring(1).toLowerCase();
        }
        catch (Throwable t) {
            System.err.println(t);
            upperString = searchString;
        }
        if (this.prefs.getBoolean("caseSensitiveSearch")) {
            score += this.doSearch(searchString, bibtexEntry);
        } else {
            score += this.doSearch(searchString, bibtexEntry);
            if (!searchString.equals(searchString.toLowerCase())) {
                score += this.doSearch(searchString.toLowerCase(), bibtexEntry);
            }
            if (!searchString.equals(searchString.toUpperCase())) {
                score += this.doSearch(searchString.toUpperCase(), bibtexEntry);
            }
            if (!searchString.equals(upperString)) {
                score += this.doSearch(upperString, bibtexEntry);
            }
        }
        return score;
    }

    public int doSearch(String searchString, BibtexEntry bibtexEntry) {
        int score = 0;
        boolean counter = false;
        if (this.prefs.getBoolean("searchAll")) {
            score += this.searchAllFields(searchString, bibtexEntry);
        } else {
            if (this.prefs.getBoolean("searchReq")) {
                score += this.searchRequiredFields(searchString, bibtexEntry);
            }
            if (this.prefs.getBoolean("searchOpt")) {
                score += this.searchOptionalFields(searchString, bibtexEntry);
            }
            if (this.prefs.getBoolean("searchGen")) {
                score += this.searchGeneralFields(searchString, bibtexEntry);
            }
        }
        return score;
    }

    public int searchRequiredFields(String searchString, BibtexEntry bibtexEntry) {
        int score = 0;
        int counter = 0;
        String[] requiredField = bibtexEntry.getRequiredFields();
        if (requiredField != null) {
            for (int i = 0; i < requiredField.length; ++i) {
                if (bibtexEntry.getField(requiredField[i]) != null) {
                    try {
                        counter = String.valueOf(bibtexEntry.getField(requiredField[i])).indexOf(searchString, counter);
                        while (counter >= 0) {
                            ++score;
                            counter = String.valueOf(bibtexEntry.getField(requiredField[i])).indexOf(searchString, counter + 1);
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("sorting error: " + t);
                    }
                }
                counter = 0;
            }
        }
        return score;
    }

    public int searchOptionalFields(String searchString, BibtexEntry bibtexEntry) {
        int score = 0;
        int counter = 0;
        String[] optionalField = bibtexEntry.getOptionalFields();
        for (int i = 0; i < optionalField.length; ++i) {
            if (bibtexEntry.getField(optionalField[i]) != null) {
                try {
                    counter = String.valueOf(bibtexEntry.getField(optionalField[i])).indexOf(searchString, counter);
                    while (counter >= 0) {
                        ++score;
                        counter = String.valueOf(bibtexEntry.getField(optionalField[i])).indexOf(searchString, counter + 1);
                    }
                }
                catch (Throwable t) {
                    System.err.println("sorting error: " + t);
                }
            }
            counter = 0;
        }
        return score;
    }

    public int searchGeneralFields(String searchString, BibtexEntry bibtexEntry) {
        int score = 0;
        int counter = 0;
        String[] generalField = bibtexEntry.getGeneralFields();
        for (int i = 0; i < generalField.length; ++i) {
            if (bibtexEntry.getField(generalField[i]) != null) {
                try {
                    counter = String.valueOf(bibtexEntry.getField(generalField[i])).indexOf(searchString, counter);
                    while (counter >= 0) {
                        ++score;
                        counter = String.valueOf(bibtexEntry.getField(generalField[i])).indexOf(searchString, counter + 1);
                    }
                }
                catch (Throwable t) {
                    System.err.println("sorting error: " + t);
                }
            }
            counter = 0;
        }
        return score;
    }

    public int searchAllFields(String searchString, BibtexEntry bibtexEntry) {
        int score = 0;
        int counter = 0;
        Object[] fields = bibtexEntry.getAllFields();
        for (int i = 0; i < fields.length; ++i) {
            if (bibtexEntry.getField(fields[i].toString()) != null) {
                try {
                    counter = String.valueOf(bibtexEntry.getField(fields[i].toString())).indexOf(searchString, counter);
                    while (counter >= 0) {
                        ++score;
                        counter = String.valueOf(bibtexEntry.getField(fields[i].toString())).indexOf(searchString, counter + 1);
                    }
                }
                catch (Throwable t) {
                    System.err.println("sorting error: " + t);
                }
            }
            counter = 0;
        }
        return score;
    }
}

