/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.EntryCustomizationDialog;
import jabref.EntryTypeDialog;
import jabref.FileHistory;
import jabref.FocusRequester;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpAction;
import jabref.HelpDialog;
import jabref.JabRefPreferences;
import jabref.KeyBindingsDialog;
import jabref.KeyCollisionException;
import jabref.PrefsDialog2;
import jabref.SetPref;
import jabref.Util;
import jabref.export.FileActions;
import jabref.imports.BibtexParser;
import jabref.imports.ImportFormatReader;
import jabref.imports.ParserResult;
import jabref.label.ArticleLabelRule;
import jabref.label.BookLabelRule;
import jabref.label.IncollectionLabelRule;
import jabref.label.InproceedingsLabelRule;
import jabref.label.LabelMaker;
import jabref.undo.NamedCompound;
import jabref.undo.UndoableInsertEntry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JabRefFrame
extends JFrame {
    JabRefFrame ths = this;
    JabRefPreferences prefs = new JabRefPreferences();
    JTabbedPane tabbedPane = new JTabbedPane();
    JToolBar tlb = new JToolBar();
    JMenuBar mb = new JMenuBar();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel statusLine = new JLabel("", 2);
    JLabel statusLabel = new JLabel(Globals.lang("Status") + ":", 2);
    FileHistory fileHistory = new FileHistory(this.prefs, this);
    LabelMaker labelMaker;
    File fileToOpen = null;
    public HelpDialog helpDiag = new HelpDialog(this);
    AbstractAction open = new OpenDatabaseAction();
    AbstractAction close = new CloseDatabaseAction();
    AbstractAction quit = new CloseAction();
    AbstractAction selectKeys = new SelectKeysAction();
    AbstractAction newDatabaseAction = new NewDatabaseAction();
    AbstractAction help = new HelpAction("JabRef help", this.helpDiag, GUIGlobals.baseFrameHelp, "JabRef help", this.prefs.getKey("Help"));
    AbstractAction contents = new HelpAction("Help contents", this.helpDiag, GUIGlobals.helpContents, "Help contents", GUIGlobals.helpContentsIconFile);
    AbstractAction about = new HelpAction("About JabRef", this.helpDiag, GUIGlobals.aboutPage, "About JabRef", GUIGlobals.aboutIcon);
    AbstractAction editEntry = new GeneralAction("edit", "Edit entry", "Edit entry", GUIGlobals.editIconFile, this.prefs.getKey("Edit entry"));
    AbstractAction save = new GeneralAction("save", "Save database", "Save database", GUIGlobals.saveIconFile, this.prefs.getKey("Save database"));
    AbstractAction saveAs = new GeneralAction("saveAs", "Save database as ...", "Save database as ...", GUIGlobals.saveAsIconFile, this.prefs.getKey("Save database as ..."));
    AbstractAction saveSelectedAs = new GeneralAction("saveSelectedAs", "Save selected as ...", "Save selected as ...", GUIGlobals.saveAsIconFile);
    AbstractAction nextTab = new ChangeTabAction(true);
    AbstractAction prevTab = new ChangeTabAction(false);
    AbstractAction undo = new GeneralAction("undo", "Undo", "Undo", GUIGlobals.undoIconFile, this.prefs.getKey("Undo"));
    AbstractAction redo = new GeneralAction("redo", "Redo", "Redo", GUIGlobals.redoIconFile, this.prefs.getKey("Redo"));
    AbstractAction delete = new GeneralAction("delete", "Delete", "Delete", GUIGlobals.removeIconFile, this.prefs.getKey("Delete"));
    AbstractAction copy = new EditAction("copy", GUIGlobals.copyIconFile);
    AbstractAction paste = new EditAction("paste", GUIGlobals.pasteIconFile);
    AbstractAction cut = new EditAction("cut", GUIGlobals.cutIconFile);
    AbstractAction mark = new GeneralAction("markEntries", "Mark entries", this.prefs.getKey("Mark entries"));
    AbstractAction unmark = new GeneralAction("unmarkEntries", "Unmark entries", this.prefs.getKey("Unmark entries"));
    AbstractAction unmarkAll = new GeneralAction("unmarkAll", "Unmark all");
    AbstractAction saveSessionAction = new SaveSessionAction();
    AbstractAction loadSessionAction = new LoadSessionAction();
    AbstractAction incrementalSearch = new GeneralAction("incSearch", "Incremental search", "Start incremental search", GUIGlobals.searchIconFile, this.prefs.getKey("Incremental search"));
    AbstractAction normalSearch = new GeneralAction("search", "Search", "Start", GUIGlobals.searchIconFile, this.prefs.getKey("Search"));
    AbstractAction fetchMedline = new FetchMedlineAction();
    AbstractAction fetchAuthorMedline = new FetchAuthorMedlineAction();
    AbstractAction copyKey = new GeneralAction("copyKey", "Copy BibTeX key");
    AbstractAction copyCiteKey = new GeneralAction("copyCiteKey", "Copy \\cite{BibTeX key}", this.prefs.getKey("Copy \\cite{BibTeX key}"));
    AbstractAction mergeDatabaseAction = new GeneralAction("mergeDatabase", "Append database", "Append contents from a BibTeX database into the currently viewed database", GUIGlobals.openIconFile);
    AbstractAction selectAll = new GeneralAction("selectAll", "Select all", this.prefs.getKey("Select all"));
    AbstractAction replaceAll = new GeneralAction("replaceAll", "Replace string", this.prefs.getKey("Replace string"));
    AbstractAction editPreamble = new GeneralAction("editPreamble", "Edit preamble", "Edit preamble", GUIGlobals.preambleIconFile, this.prefs.getKey("Edit preamble"));
    AbstractAction editStrings = new GeneralAction("editStrings", "Edit strings", "Edit strings", GUIGlobals.stringsIconFile, this.prefs.getKey("Edit strings"));
    AbstractAction toggleGroups = new GeneralAction("toggleGroups", "Toggle groups interface", "Toggle groups interface", GUIGlobals.groupsIconFile, this.prefs.getKey("Toggle groups interface"));
    AbstractAction togglePreview = new GeneralAction("togglePreview", "Toggle entry preview", this.prefs.getKey("Toggle entry preview"));
    AbstractAction makeKeyAction = new GeneralAction("makeKey", "Autogenerate BibTeX keys", "Autogenerate BibTeX keys", GUIGlobals.genKeyIconFile, this.prefs.getKey("Autogenerate BibTeX keys"));
    AbstractAction lyxPushAction = new GeneralAction("pushToLyX", "Insert selected citations into jeHEP", "push selection to jeHEP", GUIGlobals.lyxIconFile, this.prefs.getKey("Push to jeHEP"));
    AbstractAction openFile = new GeneralAction("openFile", "Open PDF or PS", "Open PDF or PS", GUIGlobals.pdfIcon, this.prefs.getKey("Open PDF or PS"));
    AbstractAction openUrl = new GeneralAction("openUrl", "Open URL or DOI", "Open URL or DOI", GUIGlobals.wwwIcon, this.prefs.getKey("Open URL or DOI"));
    AbstractAction dupliCheck = new GeneralAction("dupliCheck", "Find duplicates");
    JMenu importMenu = new JMenu(Globals.lang("Import and append"));
    JMenu importNewMenu = new JMenu(Globals.lang("Import"));
    JMenu exportMenu = new JMenu(Globals.lang("Export"));
    NewEntryAction newEntryAction = new NewEntryAction(this.prefs.getKey("New entry"));
    NewEntryAction[] newSpecificEntryAction = new NewEntryAction[]{new NewEntryAction("article", this.prefs.getKey("New article")), new NewEntryAction("book", this.prefs.getKey("New book")), new NewEntryAction("phdthesis", this.prefs.getKey("New phdthesis")), new NewEntryAction("inbook", this.prefs.getKey("New inbook")), new NewEntryAction("mastersthesis", this.prefs.getKey("New mastersthesis")), new NewEntryAction("proceedings", this.prefs.getKey("New proceedings")), new NewEntryAction("inproceedings"), new NewEntryAction("incollection"), new NewEntryAction("booklet"), new NewEntryAction("manual"), new NewEntryAction("techreport"), new NewEntryAction("unpublished", this.prefs.getKey("New unpublished")), new NewEntryAction("misc")};
    CloseDatabaseAction closeDatabaseAction = new CloseDatabaseAction();
    OpenDatabaseAction openDatabaseAction = new OpenDatabaseAction();
    AbstractAction showPrefs = new ShowPrefsAction();
    AboutAction aboutAction = new AboutAction();
    JMenuItem htmlItem = new JMenuItem(Globals.lang("HTML"));
    JMenuItem simpleHtmlItem = new JMenuItem(Globals.lang("Simple HTML"));
    JMenuItem docbookItem = new JMenuItem(Globals.lang("Docbook"));
    JMenuItem bibtexmlItem = new JMenuItem(Globals.lang("BibTeXML"));

    public JabRefFrame() {
        this.init();
        if (this.prefs.getBoolean("openLastEdited") && this.prefs.get("lastEdited") != null) {
            String[] names = this.prefs.getStringArray("lastEdited");
            for (int i = 0; i < names.length; ++i) {
                this.fileToOpen = new File(names[i]);
                if (!this.fileToOpen.exists()) continue;
                this.openDatabaseAction.openIt(i == 0);
            }
            this.output(Globals.lang("Files opened") + ": " + this.tabbedPane.getTabCount());
        }
        this.setVisible(true);
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(0);
            new FocusRequester(((BasePanel)this.tabbedPane.getComponentAt((int)0)).entryTable);
        } else {
            this.setEmptyState();
        }
    }

    private void init() {
        this.macOSXRegistration();
        this.setTitle(GUIGlobals.frameTitle);
        this.setIconImage(new ImageIcon(GUIGlobals.jabreflogo).getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new CloseAction().actionPerformed(null);
            }
        });
        this.initLabelMaker();
        this.setupLayout();
        this.setSize(new Dimension(this.prefs.getInt("sizeX"), this.prefs.getInt("sizeY")));
        this.setLocation(new Point(this.prefs.getInt("posX"), this.prefs.getInt("posY")));
    }

    public void about() {
        JDialog about = new JDialog(this.ths, Globals.lang("About JabRef"), true);
        JEditorPane jp = new JEditorPane();
        JScrollPane sp = new JScrollPane(jp, 20, 31);
        jp.setEditable(false);
        try {
            jp.setPage(GUIGlobals.class.getResource("/jabref/help/About.html"));
            jp.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            ((JEditorPane)e.getSource()).setPage(e.getURL());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            about.getContentPane().add(sp);
            about.setSize(GUIGlobals.aboutSize);
            Util.placeDialog(about, this.ths);
            about.setVisible(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.ths, "Could not load file 'About.html'", "Error", 0);
        }
    }

    public void preferences() {
        PrefsDialog2 pd = new PrefsDialog2(this.ths, this.prefs);
        Util.placeDialog(pd, this.ths);
        pd.setVisible(true);
    }

    public void quit() {
        boolean close = true;
        Vector<String> filenames = new Vector<String>();
        if (this.tabbedPane.getTabCount() > 0) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (this.baseAt((int)i).baseChanged) {
                    this.tabbedPane.setSelectedIndex(i);
                    int answer = JOptionPane.showConfirmDialog(this.ths, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                    if (answer == 2 || answer == -1) {
                        close = false;
                    }
                    if (answer == 0) {
                        try {
                            this.basePanel().runCommand("save");
                        }
                        catch (Throwable ex) {
                            close = false;
                            break;
                        }
                    }
                }
                if (this.baseAt((int)i).file == null) continue;
                filenames.add(this.baseAt((int)i).file.getPath());
            }
        }
        if (close) {
            this.dispose();
            this.prefs.putInt("posX", this.ths.getLocation().x);
            this.prefs.putInt("posY", this.ths.getLocation().y);
            this.prefs.putInt("sizeX", this.ths.getSize().width);
            this.prefs.putInt("sizeY", this.ths.getSize().height);
            if (this.prefs.getBoolean("openLastEdited")) {
                if (filenames.size() == 0) {
                    this.prefs.remove("lastEdited");
                } else {
                    String[] names = new String[filenames.size()];
                    for (int i = 0; i < filenames.size(); ++i) {
                        names[i] = (String)filenames.elementAt(i);
                    }
                    this.prefs.putStringArray("lastEdited", names);
                }
            }
            this.fileHistory.storeHistory();
            BibtexEntryType.saveCustomEntryTypes(this.prefs);
            if (this.basePanel() != null) {
                this.basePanel().searchManager.updatePrefs();
            }
            SetPref.Write();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void macOSXRegistration() {
        if (Globals.osName.equals("Mac OS X")) {
            try {
                Class<?> osxAdapter = Class.forName("osxadapter.OSXAdapter");
                Class[] defArgs = new Class[]{JabRefFrame.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                if (prefsEnableMethod != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    private void setupLayout() {
        this.fillMenu();
        this.createToolBar();
        this.getContentPane().setLayout(this.gbl);
        this.getContentPane().setBackground(GUIGlobals.lightGray);
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 0;
        this.mb.setMinimumSize(this.mb.getPreferredSize());
        this.setJMenuBar(this.mb);
        this.con.anchor = 11;
        this.gbl.setConstraints(this.tlb, this.con);
        this.getContentPane().add(this.tlb);
        Component lim = Box.createGlue();
        this.gbl.setConstraints(lim, this.con);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.fill = 1;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 0, 0, 0);
        lim = Box.createGlue();
        this.gbl.setConstraints(lim, this.con);
        this.getContentPane().add(lim);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.tabbedPane, this.con);
        this.getContentPane().add(this.tabbedPane);
        JPanel status = new JPanel();
        status.setLayout(this.gbl);
        this.con.weighty = 0.0;
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        status.add(this.statusLabel);
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 4, 0, 0);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.statusLine, this.con);
        status.add(this.statusLine);
        this.con.gridwidth = 0;
        this.statusLabel.setForeground(GUIGlobals.nullFieldColor.darker());
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(status, this.con);
        this.getContentPane().add(status);
    }

    private void initLabelMaker() {
        this.labelMaker = new LabelMaker();
        this.labelMaker.addRule(new ArticleLabelRule(), BibtexEntryType.ARTICLE);
        this.labelMaker.addRule(new BookLabelRule(), BibtexEntryType.BOOK);
        this.labelMaker.addRule(new IncollectionLabelRule(), BibtexEntryType.INCOLLECTION);
        this.labelMaker.addRule(new InproceedingsLabelRule(), BibtexEntryType.INPROCEEDINGS);
    }

    BasePanel baseAt(int i) {
        return (BasePanel)this.tabbedPane.getComponentAt(i);
    }

    BasePanel basePanel() {
        return (BasePanel)this.tabbedPane.getSelectedComponent();
    }

    private int getTabIndex(JComponent comp) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != comp) continue;
            return i;
        }
        return -1;
    }

    public String getTabTitle(JComponent comp) {
        return this.tabbedPane.getTitleAt(this.getTabIndex(comp));
    }

    public void setTabTitle(JComponent comp, String s) {
        this.tabbedPane.setTitleAt(this.getTabIndex(comp), s);
    }

    private void fillMenu() {
        JMenu file2 = new JMenu(Globals.lang("File"));
        JMenu edit2 = new JMenu(Globals.lang("Edit"));
        JMenu bibtex = new JMenu(Globals.lang("BibTeX"));
        JMenu view2 = new JMenu(Globals.lang("View"));
        JMenu tools2 = new JMenu(Globals.lang("Tools"));
        JMenu options = new JMenu(Globals.lang("Options"));
        JMenu newSpec = new JMenu(Globals.lang("New entry..."));
        JMenu helpMenu = new JMenu(Globals.lang("Help"));
        this.setUpImportMenu(this.importMenu, false);
        this.setUpImportMenu(this.importNewMenu, true);
        this.setUpExportMenu(this.exportMenu);
        file2.add(this.newDatabaseAction);
        file2.add(this.open);
        file2.add(this.mergeDatabaseAction);
        file2.add(this.importMenu);
        file2.add(this.importMenu);
        file2.add(this.importNewMenu);
        file2.add(this.save);
        file2.add(this.saveAs);
        file2.add(this.saveSelectedAs);
        file2.add(this.exportMenu);
        file2.addSeparator();
        file2.add(this.fileHistory);
        file2.add(this.loadSessionAction);
        file2.add(this.saveSessionAction);
        file2.addSeparator();
        file2.add(this.close);
        file2.add(this.quit);
        this.mb.add(file2);
        edit2.add(this.undo);
        edit2.add(this.redo);
        edit2.addSeparator();
        edit2.add(this.cut);
        edit2.add(this.copy);
        edit2.add(this.paste);
        edit2.add(this.delete);
        edit2.add(this.copyKey);
        edit2.add(this.copyCiteKey);
        edit2.addSeparator();
        edit2.add(this.mark);
        edit2.add(this.unmark);
        edit2.add(this.unmarkAll);
        edit2.addSeparator();
        edit2.add(this.selectAll);
        this.mb.add(edit2);
        view2.add(this.nextTab);
        view2.add(this.prevTab);
        view2.addSeparator();
        view2.add(this.togglePreview);
        view2.add(this.toggleGroups);
        this.mb.add(view2);
        bibtex.add(this.newEntryAction);
        for (int i = 0; i < this.newSpecificEntryAction.length; ++i) {
            newSpec.add(this.newSpecificEntryAction[i]);
        }
        bibtex.add(newSpec);
        bibtex.addSeparator();
        bibtex.add(this.editEntry);
        bibtex.add(this.editPreamble);
        bibtex.add(this.editStrings);
        this.mb.add(bibtex);
        tools2.add(this.normalSearch);
        tools2.add(this.incrementalSearch);
        tools2.add(this.replaceAll);
        tools2.add(this.dupliCheck);
        tools2.addSeparator();
        tools2.add(this.makeKeyAction);
        tools2.add(this.lyxPushAction);
        tools2.add(this.fetchMedline);
        tools2.add(this.openFile);
        tools2.add(this.openUrl);
        this.mb.add(tools2);
        options.add(this.showPrefs);
        options.add(new AbstractAction(Globals.lang("Customize entry types")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog dl = new EntryCustomizationDialog(JabRefFrame.this.ths);
                Util.placeDialog(dl, JabRefFrame.this.ths);
                dl.setVisible(true);
            }
        });
        this.mb.add(options);
        helpMenu.add(this.help);
        helpMenu.add(this.contents);
        helpMenu.addSeparator();
        helpMenu.add(this.about);
        this.mb.add(helpMenu);
    }

    private void createToolBar() {
        this.tlb.setBackground(GUIGlobals.lightGray);
        this.tlb.setForeground(GUIGlobals.lightGray);
        this.tlb.setFloatable(false);
        this.tlb.add(this.newDatabaseAction);
        this.tlb.add(this.open);
        this.tlb.add(this.save);
        this.tlb.addSeparator();
        this.tlb.add(this.cut);
        this.tlb.add(this.copy);
        this.tlb.add(this.paste);
        this.tlb.addSeparator();
        this.tlb.add(this.undo);
        this.tlb.add(this.redo);
        this.tlb.addSeparator();
        this.tlb.add(this.newEntryAction);
        this.tlb.add(this.editEntry);
        this.tlb.add(this.editPreamble);
        this.tlb.add(this.editStrings);
        this.tlb.add(this.makeKeyAction);
        this.tlb.add(this.lyxPushAction);
        this.tlb.add(this.openFile);
        this.tlb.add(this.openUrl);
        this.tlb.addSeparator();
        this.tlb.add(this.normalSearch);
        this.tlb.add(this.toggleGroups);
        this.tlb.addSeparator();
        this.tlb.add(this.showPrefs);
        this.tlb.add(Box.createHorizontalGlue());
        this.tlb.add(this.closeDatabaseAction);
    }

    private JMenuItem mItem(AbstractAction a, KeyStroke ks) {
        JMenuItem mi = new JMenuItem();
        mi.setAction(a);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    public void output(String s) {
        this.statusLine.setText(s);
        this.statusLine.repaint();
    }

    public void stopShowingSearchResults() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).stopShowingSearchResults();
        }
    }

    private void setEmptyState() {
        this.mergeDatabaseAction.setEnabled(false);
        this.close.setEnabled(false);
        this.save.setEnabled(false);
        this.saveAs.setEnabled(false);
        this.saveSelectedAs.setEnabled(false);
        this.nextTab.setEnabled(false);
        this.prevTab.setEnabled(false);
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        this.cut.setEnabled(false);
        this.delete.setEnabled(false);
        this.copy.setEnabled(false);
        this.paste.setEnabled(false);
        this.mark.setEnabled(false);
        this.unmark.setEnabled(false);
        this.unmarkAll.setEnabled(false);
        this.editEntry.setEnabled(false);
        this.selectAll.setEnabled(false);
        this.copyKey.setEnabled(false);
        this.copyCiteKey.setEnabled(false);
        this.editPreamble.setEnabled(false);
        this.editStrings.setEnabled(false);
        this.toggleGroups.setEnabled(false);
        this.makeKeyAction.setEnabled(false);
        this.lyxPushAction.setEnabled(false);
        this.normalSearch.setEnabled(false);
        this.incrementalSearch.setEnabled(false);
        this.replaceAll.setEnabled(false);
        this.importMenu.setEnabled(false);
        this.exportMenu.setEnabled(false);
        this.fetchMedline.setEnabled(false);
        this.openFile.setEnabled(false);
        this.openUrl.setEnabled(false);
        this.togglePreview.setEnabled(false);
        for (int i = 0; i < this.newSpecificEntryAction.length; ++i) {
            this.newSpecificEntryAction[i].setEnabled(false);
        }
        this.newEntryAction.setEnabled(false);
        this.closeDatabaseAction.setEnabled(false);
    }

    private void setNonEmptyState() {
        this.mergeDatabaseAction.setEnabled(true);
        this.close.setEnabled(true);
        this.save.setEnabled(true);
        this.saveAs.setEnabled(true);
        this.saveSelectedAs.setEnabled(true);
        this.nextTab.setEnabled(true);
        this.prevTab.setEnabled(true);
        this.undo.setEnabled(true);
        this.redo.setEnabled(true);
        this.cut.setEnabled(true);
        this.delete.setEnabled(true);
        this.copy.setEnabled(true);
        this.paste.setEnabled(true);
        this.mark.setEnabled(true);
        this.unmark.setEnabled(true);
        this.unmarkAll.setEnabled(true);
        this.editEntry.setEnabled(true);
        this.selectAll.setEnabled(true);
        this.copyKey.setEnabled(true);
        this.copyCiteKey.setEnabled(true);
        this.editPreamble.setEnabled(true);
        this.editStrings.setEnabled(true);
        this.toggleGroups.setEnabled(true);
        this.makeKeyAction.setEnabled(true);
        this.lyxPushAction.setEnabled(true);
        this.normalSearch.setEnabled(true);
        this.incrementalSearch.setEnabled(true);
        this.replaceAll.setEnabled(true);
        this.importMenu.setEnabled(true);
        this.exportMenu.setEnabled(true);
        this.fetchMedline.setEnabled(true);
        this.openFile.setEnabled(true);
        this.openUrl.setEnabled(true);
        this.togglePreview.setEnabled(true);
        for (int i = 0; i < this.newSpecificEntryAction.length; ++i) {
            this.newSpecificEntryAction[i].setEnabled(true);
        }
        this.newEntryAction.setEnabled(true);
        this.closeDatabaseAction.setEnabled(true);
    }

    public void setupAllTables() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel bf = this.baseAt(i);
            if (bf.database == null) continue;
            bf.entryTable.updateFont();
            bf.setupTable();
        }
    }

    protected ParserResult loadDatabase(File fileToOpen) throws IOException {
        BibtexParser bp = new BibtexParser(new FileReader(fileToOpen));
        ParserResult pr = bp.parse();
        return pr;
    }

    private void addBibEntries(ArrayList bibentries, String filename, boolean intoNew) {
        if (this.prefs.getBoolean("useOwner")) {
            Util.setDefaultOwner(bibentries, this.prefs.get("defaultOwner"));
        }
        if (bibentries == null) {
            this.output(Globals.lang("Ne entries imported."));
            return;
        }
        if (intoNew || this.tabbedPane.getTabCount() == 0) {
            BibtexDatabase database = new BibtexDatabase();
            for (BibtexEntry entry : bibentries) {
                try {
                    entry.setId(Util.createId(entry.getType(), database));
                    database.insertEntry(entry);
                }
                catch (KeyCollisionException ex) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            HashMap meta = new HashMap();
            BasePanel bp = new BasePanel(this.ths, database, null, meta, this.prefs);
            this.tabbedPane.add(Globals.lang("untitled"), bp);
            bp.markBaseChanged();
            this.tabbedPane.setSelectedComponent(bp);
            if (this.tabbedPane.getTabCount() == 1) {
                this.setNonEmptyState();
            }
            this.output(Globals.lang("Imported database") + " '" + filename + "' " + Globals.lang("with") + " " + database.getEntryCount() + " " + Globals.lang("entries into new database") + ".");
        } else {
            BasePanel basePanel = this.basePanel();
            BibtexDatabase database = basePanel.database;
            int oldCount = database.getEntryCount();
            NamedCompound ce = new NamedCompound("Import database");
            for (BibtexEntry entry : bibentries) {
                try {
                    entry.setId(Util.createId(entry.getType(), database));
                    database.insertEntry(entry);
                    ce.addEdit(new UndoableInsertEntry(database, entry, basePanel));
                }
                catch (KeyCollisionException ex) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            ce.end();
            basePanel.undoManager.addEdit(ce);
            basePanel.markBaseChanged();
            basePanel.refreshTable();
            this.output(Globals.lang("Imported database") + " '" + filename + "' " + Globals.lang("with") + " " + (database.getEntryCount() - oldCount) + " " + Globals.lang("entries into new database") + ".");
        }
    }

    private void setUpImportMenu(JMenu importMenu, boolean intoNew_) {
        final boolean intoNew = intoNew_;
        JMenuItem newEndnoteFile_mItem = new JMenuItem(Globals.lang("Refer/Endnote"));
        newEndnoteFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readEndnote(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newEndnoteFile_mItem);
        JMenuItem newINSPECFile_mItem = new JMenuItem(Globals.lang("INSPEC"));
        newINSPECFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readINSPEC(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newINSPECFile_mItem);
        JMenuItem newISIFile_mItem = new JMenuItem(Globals.lang("ISI"));
        newISIFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readISI(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newISIFile_mItem);
        JMenuItem newMedlineFile_mItem = new JMenuItem(Globals.lang("Medline XML File"));
        newMedlineFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readMedline(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newMedlineFile_mItem);
        JMenuItem newBibTeXMLFile_mItem = new JMenuItem(Globals.lang("BibTeXML File"));
        newBibTeXMLFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readBibTeXML(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newBibTeXMLFile_mItem);
        JMenuItem newOvidFile_mItem = new JMenuItem(Globals.lang("Ovid"));
        newOvidFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readOvid(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newOvidFile_mItem);
        JMenuItem newRefMan_mItem = new JMenuItem(Globals.lang("RIS"));
        newRefMan_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readReferenceManager10(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newRefMan_mItem);
        JMenuItem newSciFinderFile_mItem = new JMenuItem(Globals.lang("SciFinder"));
        newSciFinderFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readScifinder(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newSciFinderFile_mItem);
        JMenuItem newSixpack_mItem = new JMenuItem(Globals.lang("Sixpack"));
        newSixpack_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readSixpack(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newSixpack_mItem);
        JMenuItem newBiblioscapeTagFile_mItem = new JMenuItem(Globals.lang("Biblioscape Tag file"));
        newBiblioscapeTagFile_mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tempFilename = JabRefFrame.this.getNewFile();
                if (tempFilename != null) {
                    ArrayList bibs = ImportFormatReader.readBiblioscapeTagFile(tempFilename);
                    JabRefFrame.this.addBibEntries(bibs, tempFilename, intoNew);
                }
            }
        });
        importMenu.add(newBiblioscapeTagFile_mItem);
    }

    public String getNewFile() {
        return Globals.getNewFile(this.ths, this.prefs, new File(this.prefs.get("workingDirectory")), null, 0, false);
    }

    private void setUpExportMenu(JMenu menu) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                String lfFileName = null;
                String extension = null;
                if (source == JabRefFrame.this.htmlItem) {
                    lfFileName = "html";
                    extension = ".html";
                }
                if (source == JabRefFrame.this.simpleHtmlItem) {
                    lfFileName = "simplehtml";
                    extension = ".html";
                } else if (source == JabRefFrame.this.docbookItem) {
                    lfFileName = "docbook";
                    extension = ".xml";
                } else if (source == JabRefFrame.this.bibtexmlItem) {
                    lfFileName = "bibtexml";
                    extension = ".xml";
                }
                File outFile = null;
                String chosenFile = Globals.getNewFile(JabRefFrame.this.ths, JabRefFrame.this.prefs, new File(JabRefFrame.this.prefs.get("workingDirectory")), extension, 1, false);
                if (chosenFile == null) {
                    return;
                }
                outFile = new File(chosenFile);
                final String lfName = lfFileName;
                final File oFile = outFile;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            FileActions.exportDatabase(JabRefFrame.this.basePanel().database, lfName, oFile, JabRefFrame.this.prefs);
                            JabRefFrame.this.output(Globals.lang("Exported database to file") + " '" + oFile.getPath() + "'.");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }.start();
            }
        };
        this.htmlItem.addActionListener(listener);
        menu.add(this.htmlItem);
        this.simpleHtmlItem.addActionListener(listener);
        menu.add(this.simpleHtmlItem);
        this.bibtexmlItem.addActionListener(listener);
        menu.add(this.bibtexmlItem);
        this.docbookItem.addActionListener(listener);
        menu.add(this.docbookItem);
    }

    class OpenDatabaseAction
    extends AbstractAction {
        public OpenDatabaseAction() {
            super(Globals.lang("Open database"), new ImageIcon(GUIGlobals.openIconFile));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Open database"));
            this.putValue("ShortDescription", Globals.lang("Open BibTeX database"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == null || e.getActionCommand().equals(Globals.lang("Open database"))) {
                String chosenFile = Globals.getNewFile(JabRefFrame.this.ths, JabRefFrame.this.prefs, new File(JabRefFrame.this.prefs.get("workingDirectory")), ".bib", 0, true);
                if (chosenFile != null) {
                    JabRefFrame.this.fileToOpen = new File(chosenFile);
                }
            } else {
                Util.pr("Name");
                Util.pr(e.getActionCommand());
                JabRefFrame.this.fileToOpen = new File(Util.checkName(e.getActionCommand()));
            }
            if (JabRefFrame.this.fileToOpen != null) {
                new Thread(){

                    @Override
                    public void run() {
                        OpenDatabaseAction.this.openIt(true);
                    }
                }.start();
                JabRefFrame.this.fileHistory.newFile(JabRefFrame.this.fileToOpen.getPath());
            }
        }

        public void openIt(boolean raisePanel) {
            if (JabRefFrame.this.fileToOpen != null && JabRefFrame.this.fileToOpen.exists()) {
                try {
                    JabRefFrame.this.prefs.put("workingDirectory", JabRefFrame.this.fileToOpen.getPath());
                    ParserResult pr = JabRefFrame.this.loadDatabase(JabRefFrame.this.fileToOpen);
                    BibtexDatabase db = pr.getDatabase();
                    HashMap meta = pr.getMetaData();
                    BasePanel bp = new BasePanel(JabRefFrame.this.ths, db, JabRefFrame.this.fileToOpen, meta, JabRefFrame.this.prefs);
                    JabRefFrame.this.tabbedPane.add(JabRefFrame.this.fileToOpen.getName(), bp);
                    if (raisePanel) {
                        JabRefFrame.this.tabbedPane.setSelectedComponent(bp);
                    }
                    if (JabRefFrame.this.tabbedPane.getTabCount() == 1) {
                        JabRefFrame.this.setNonEmptyState();
                    }
                    JabRefFrame.this.output(Globals.lang("Opened database") + " '" + JabRefFrame.this.fileToOpen.getPath() + "' " + Globals.lang("with") + " " + db.getEntryCount() + " " + Globals.lang("entries") + ".");
                    JabRefFrame.this.fileToOpen = null;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(JabRefFrame.this.ths, ex.getMessage(), Globals.lang("Open database"), 0);
                }
            }
        }
    }

    class CloseDatabaseAction
    extends AbstractAction {
        public CloseDatabaseAction() {
            super(Globals.lang("Close database"), new ImageIcon(GUIGlobals.closeIconFile));
            this.putValue("ShortDescription", Globals.lang("Close the current database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Close database"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean close = true;
            if (JabRefFrame.this.basePanel() == null) {
                return;
            }
            if (JabRefFrame.this.basePanel().baseChanged) {
                int answer = JOptionPane.showConfirmDialog(JabRefFrame.this.ths, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                if (answer == 2 || answer == -1) {
                    close = false;
                }
                if (answer == 0) {
                    try {
                        JabRefFrame.this.basePanel().runCommand("save");
                    }
                    catch (Throwable ex) {
                        close = false;
                    }
                }
            }
            if (close) {
                JabRefFrame.this.tabbedPane.remove(JabRefFrame.this.basePanel());
                if (JabRefFrame.this.tabbedPane.getTabCount() == 0) {
                    JabRefFrame.this.setEmptyState();
                }
                JabRefFrame.this.output(Globals.lang("Closed database") + ".");
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Quit"));
            this.putValue("ShortDescription", Globals.lang("Quit JabRef"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Quit JabRef"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.quit();
        }
    }

    class SelectKeysAction
    extends AbstractAction {
        public SelectKeysAction() {
            super(Globals.lang("Customize key bindings"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyBindingsDialog d = new KeyBindingsDialog((HashMap)JabRefFrame.this.prefs.getKeyBindings().clone(), JabRefFrame.this.prefs.getDefaultKeys());
            d.setDefaultCloseOperation(3);
            d.pack();
            Util.placeDialog(d, JabRefFrame.this.ths);
            d.setVisible(true);
            if (d.getAction()) {
                JabRefFrame.this.prefs.setNewKeyBindings(d.getNewKeyBindings());
                JOptionPane.showMessageDialog(JabRefFrame.this.ths, Globals.lang("Your new key bindings have been stored.") + "\n" + Globals.lang("You must restart JabRef for the new key bindings to work properly."), Globals.lang("Key bindings changed"), 1);
            }
        }
    }

    class NewDatabaseAction
    extends AbstractAction {
        public NewDatabaseAction() {
            super(Globals.lang("New database"), new ImageIcon(GUIGlobals.newIconFile));
            this.putValue("ShortDescription", Globals.lang("New BibTeX database"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasePanel bp = new BasePanel(JabRefFrame.this.ths, JabRefFrame.this.prefs);
            JabRefFrame.this.tabbedPane.add(Globals.lang(GUIGlobals.untitledTitle), bp);
            JabRefFrame.this.tabbedPane.setSelectedComponent(bp);
            if (JabRefFrame.this.tabbedPane.getTabCount() == 1) {
                JabRefFrame.this.setNonEmptyState();
            }
            JabRefFrame.this.output(Globals.lang("New database created."));
        }
    }

    class GeneralAction
    extends AbstractAction {
        private String command;

        public GeneralAction(String command, String text, String description, URL icon) {
            super(Globals.lang(text), new ImageIcon(icon));
            this.command = command;
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public GeneralAction(String command, String text, String description, URL icon, KeyStroke key) {
            super(Globals.lang(text), new ImageIcon(icon));
            this.command = command;
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public GeneralAction(String command, String text) {
            super(Globals.lang(text));
            this.command = command;
        }

        public GeneralAction(String command, String text, KeyStroke key) {
            super(Globals.lang(text));
            this.command = command;
            this.putValue("AcceleratorKey", key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                try {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).runCommand(this.command);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else {
                Util.pr("Action '" + this.command + "' must be disabled when no database is open.");
            }
        }
    }

    class ChangeTabAction
    extends AbstractAction {
        private boolean next;

        public ChangeTabAction(boolean next) {
            super(Globals.lang(next ? "Next tabclose" : "Previous tabclose"));
            this.next = next;
            this.putValue("AcceleratorKey", next ? JabRefFrame.this.prefs.getKey("Next tabclose") : JabRefFrame.this.prefs.getKey("Previous tabclose"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newI;
            int i = JabRefFrame.this.tabbedPane.getSelectedIndex();
            int n = newI = this.next ? i + 1 : i - 1;
            if (newI < 0) {
                newI = JabRefFrame.this.tabbedPane.getTabCount() - 1;
            }
            if (newI == JabRefFrame.this.tabbedPane.getTabCount()) {
                newI = 0;
            }
            JabRefFrame.this.tabbedPane.setSelectedIndex(newI);
        }
    }

    class EditAction
    extends AbstractAction {
        private String command;

        public EditAction(String command, URL icon) {
            super(Globals.lang(Util.nCase(command)), new ImageIcon(icon));
            this.command = command;
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey(Util.nCase(command)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent source = Globals.focusListener.getFocused();
            try {
                source.getActionMap().get(this.command).actionPerformed(new ActionEvent(source, 0, this.command));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class SaveSessionAction
    extends AbstractAction {
        public SaveSessionAction() {
            super(Globals.lang("Save session"), new ImageIcon(GUIGlobals.saveIconFile));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Save session"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector<String> filenames = new Vector<String>();
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                    if (JabRefFrame.this.tabbedPane.getTitleAt(i).equals(GUIGlobals.untitledTitle)) {
                        JabRefFrame.this.tabbedPane.setSelectedIndex(i);
                        int answer = JOptionPane.showConfirmDialog(JabRefFrame.this.ths, Globals.lang("This untitled database must be saved first to be included in the saved session. Save now?"), Globals.lang("Save database"), 0);
                        if (answer == 0) {
                            try {
                                JabRefFrame.this.basePanel().runCommand("save");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (JabRefFrame.this.baseAt((int)i).file == null) continue;
                    filenames.add(JabRefFrame.this.baseAt((int)i).file.getPath());
                }
            }
            if (filenames.size() == 0) {
                JabRefFrame.this.output(Globals.lang("Not saved (empty session)") + ".");
                return;
            }
            String[] names = new String[filenames.size()];
            for (int i = 0; i < filenames.size(); ++i) {
                names[i] = (String)filenames.elementAt(i);
            }
            JabRefFrame.this.prefs.putStringArray("savedSession", names);
            JabRefFrame.this.output(Globals.lang("Saved session") + ".");
        }
    }

    class LoadSessionAction
    extends AbstractAction {
        public LoadSessionAction() {
            super(Globals.lang("Load session"), new ImageIcon(GUIGlobals.openIconFile));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Load session"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.prefs.get("savedSession") == null) {
                JabRefFrame.this.output(Globals.lang("No saved session found."));
                return;
            }
            JabRefFrame.this.output(Globals.lang("Loading session..."));
            new Thread(){

                @Override
                public void run() {
                    HashSet<String> currentFiles = new HashSet<String>();
                    if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                        for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                            currentFiles.add(JabRefFrame.this.baseAt((int)i).file.getPath());
                        }
                    }
                    int i0 = JabRefFrame.this.tabbedPane.getTabCount();
                    String[] names = JabRefFrame.this.prefs.getStringArray("savedSession");
                    for (int i = 0; i < names.length; ++i) {
                        if (currentFiles.contains(names[i])) continue;
                        JabRefFrame.this.fileToOpen = new File(names[i]);
                        if (!JabRefFrame.this.fileToOpen.exists()) continue;
                        JabRefFrame.this.openDatabaseAction.openIt(i == 0);
                    }
                    JabRefFrame.this.output(Globals.lang("Files opened") + ": " + (JabRefFrame.this.tabbedPane.getTabCount() - i0));
                }
            }.start();
        }
    }

    class FetchMedlineAction
    extends AbstractAction {
        public FetchMedlineAction() {
            super(Globals.lang("Fetch Medline"), new ImageIcon(GUIGlobals.fetchMedlineIcon));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Fetch Medline"));
            this.putValue("ShortDescription", Globals.lang("Fetch Medline by ID"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getComponentAt((int)i)).sidePaneManager.ensureVisible("fetchMedline");
                    new FocusRequester(JabRefFrame.this.basePanel().medlineFetcher);
                }
            }
        }
    }

    class FetchAuthorMedlineAction
    extends AbstractAction {
        public FetchAuthorMedlineAction() {
            super(Globals.lang("Fetch Medline by author"), new ImageIcon(GUIGlobals.fetchMedlineIcon));
            this.putValue("ShortDescription", Globals.lang("Fetch Medline by author"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getComponentAt((int)i)).sidePaneManager.ensureVisible("fetchAuthorMedline");
                    new FocusRequester(JabRefFrame.this.basePanel().medlineFetcher);
                }
            }
        }
    }

    class NewEntryAction
    extends AbstractAction {
        String type;
        KeyStroke keyStroke;

        public NewEntryAction(KeyStroke key) {
            super(Globals.lang("New entry"), new ImageIcon(GUIGlobals.addIconFile));
            this.type = null;
            this.keyStroke = null;
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", Globals.lang("New BibTeX entry"));
        }

        public NewEntryAction(String type_) {
            super(Util.nCase(type_));
            this.type = null;
            this.keyStroke = null;
            this.type = type_;
        }

        public NewEntryAction(String type_, KeyStroke key) {
            super(Util.nCase(type_));
            this.type = null;
            this.keyStroke = null;
            this.putValue("AcceleratorKey", key);
            this.type = type_;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String thisType = this.type;
            if (thisType == null) {
                EntryTypeDialog etd = new EntryTypeDialog(JabRefFrame.this.ths);
                Util.placeDialog(etd, JabRefFrame.this.ths);
                etd.setVisible(true);
                BibtexEntryType tp = etd.getChoice();
                if (tp == null) {
                    return;
                }
                thisType = tp.getName();
            }
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).newEntry(BibtexEntryType.getType(thisType));
            } else {
                Util.pr("Action 'New entry' must be disabled when no database is open.");
            }
        }
    }

    class ShowPrefsAction
    extends AbstractAction {
        public ShowPrefsAction() {
            super(Globals.lang("Preferences"), new ImageIcon(GUIGlobals.prefsIconFile));
            this.putValue("ShortDescription", Globals.lang("Preferences"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.preferences();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(Globals.lang("About JabRef"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.about();
        }
    }

    private class JabRefLabel
    extends JPanel {
        private String label;

        public JabRefLabel(String name) {
            this.label = name;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(GUIGlobals.nullFieldColor);
            g2.setFont(GUIGlobals.jabRefFont);
            FontMetrics fm = g2.getFontMetrics();
            int width = fm.stringWidth(this.label);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawString(this.label, this.getWidth() - width - 7, this.getHeight() - 10);
        }
    }
}

