/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.JabRefPreferences;

public class IncrementalSearcher {
    JabRefPreferences prefs;
    private String hitInField;

    public IncrementalSearcher(JabRefPreferences prefs2) {
        this.prefs = prefs2;
    }

    public String getField() {
        return this.hitInField;
    }

    public boolean search(String pattern, BibtexEntry bibtexEntry) {
        Object[] generalField;
        Object[] optionalField;
        Object[] requiredField;
        this.hitInField = null;
        if (this.prefs.getBoolean("searchAll")) {
            Object[] fields = bibtexEntry.getAllFields();
            return this.searchFields(fields, bibtexEntry, pattern);
        }
        if (this.prefs.getBoolean("searchReq") && this.searchFields(requiredField = bibtexEntry.getRequiredFields(), bibtexEntry, pattern)) {
            return true;
        }
        if (this.prefs.getBoolean("searchOpt") && this.searchFields(optionalField = bibtexEntry.getOptionalFields(), bibtexEntry, pattern)) {
            return true;
        }
        return this.prefs.getBoolean("searchGen") && this.searchFields(generalField = bibtexEntry.getGeneralFields(), bibtexEntry, pattern);
    }

    protected boolean searchFields(Object[] fields, BibtexEntry bibtexEntry, String searchString) {
        boolean found = false;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (bibtexEntry.getField(fields[i].toString()) == null) continue;
                    if (this.prefs.getBoolean("caseSensitiveSearch")) {
                        if (bibtexEntry.getField(fields[i].toString()).toString().indexOf(searchString) > -1) {
                            found = true;
                        }
                    } else if (bibtexEntry.getField(fields[i].toString()).toString().toLowerCase().indexOf(searchString.toLowerCase()) > -1) {
                        found = true;
                    }
                    if (!found) continue;
                    this.hitInField = fields[i].toString();
                    return true;
                }
                catch (Throwable t) {
                    System.err.println("Searching error: " + t);
                }
            }
        }
        return false;
    }
}

