/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntryType;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.KeyCollisionException;
import jabref.Util;
import jabref.export.FieldFormatter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class BibtexEntry {
    private String _id;
    private BibtexEntryType _type;
    private Map _fields = new HashMap();
    VetoableChangeSupport _changeSupport = new VetoableChangeSupport(this);

    public BibtexEntry(String id) {
        this(id, BibtexEntryType.OTHER);
    }

    public BibtexEntry(String id, BibtexEntryType type) {
        if (id == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        this._id = id;
        this.setType(type);
    }

    public String[] getOptionalFields() {
        return this._type.getOptionalFields();
    }

    public String[] getRequiredFields() {
        return this._type.getRequiredFields();
    }

    public String[] getGeneralFields() {
        return this._type.getGeneralFields();
    }

    public Object[] getAllFields() {
        return this._fields.keySet().toArray();
    }

    public String describeRequiredFields() {
        return this._type.describeRequiredFields();
    }

    public boolean hasAllRequiredFields() {
        return this._type.hasAllRequiredFields(this);
    }

    public BibtexEntryType getType() {
        return this._type;
    }

    public void setType(BibtexEntryType type) {
        if (type == null) {
            throw new NullPointerException("Every BibtexEntry must have a type.  Instead of null, use type OTHER");
        }
        this._type = type;
    }

    public boolean updateType() {
        BibtexEntryType newType = BibtexEntryType.getType(this._type.getName());
        if (newType != null) {
            this._type = newType;
            return true;
        }
        this._type = BibtexEntryType.TYPELESS;
        return false;
    }

    public void setId(String id) throws KeyCollisionException {
        if (id == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        try {
            this.firePropertyChangedEvent("id", this._id, id);
        }
        catch (PropertyVetoException pv) {
            throw new KeyCollisionException("Couldn't change ID: " + pv);
        }
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public Object getField(String name) {
        return this._fields.get(name);
    }

    public String getCiteKey() {
        return this._fields.containsKey("bibtexkey") ? (String)this._fields.get("bibtexkey") : null;
    }

    public void setField(HashMap fields) {
        this._fields.putAll(fields);
    }

    public void setField(String name, Object value) {
        if ("id".equals(name)) {
            throw new IllegalArgumentException("The field name '" + name + "' is reserved");
        }
        try {
            this.firePropertyChangedEvent(name, this._fields.get(name), value);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException("Change rejected: " + pve);
        }
        this._fields.put(name, value);
    }

    protected boolean allFieldsPresent(String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (this.getField(fields[i]) != null) continue;
            return false;
        }
        return true;
    }

    private void firePropertyChangedEvent(String fieldName, Object oldValue, Object newValue) throws PropertyVetoException {
        this._changeSupport.fireVetoableChange(new PropertyChangeEvent(this, fieldName, oldValue, newValue));
    }

    public void addPropertyChangeListener(VetoableChangeListener listener) {
        this._changeSupport.addVetoableChangeListener(listener);
    }

    public void removePropertyChangeListener(VetoableChangeListener listener) {
        this._changeSupport.removeVetoableChangeListener(listener);
    }

    public void write(Writer out, FieldFormatter ff, boolean write) throws IOException {
        int i;
        out.write("@" + this._type.getName().toUpperCase() + "{");
        String str = Util.shaveString((String)this.getField(GUIGlobals.KEY_FIELD));
        out.write((str == null ? "" : str.toString()) + ",\n");
        HashMap written = new HashMap();
        written.put(GUIGlobals.KEY_FIELD, null);
        String[] s = this.getRequiredFields();
        if (s != null) {
            for (i = 0; i < s.length; ++i) {
                this.writeField(s[i], out, ff);
                written.put(s[i], null);
            }
        }
        if ((s = this.getOptionalFields()) != null) {
            for (i = 0; i < s.length; ++i) {
                this.writeField(s[i], out, ff);
                written.put(s[i], null);
            }
        }
        for (String key : this._fields.keySet()) {
            boolean writeIt;
            boolean bl = writeIt = write ? GUIGlobals.isWriteableField(key) : GUIGlobals.isDisplayableField(key);
            if (written.containsKey(key) || !writeIt) continue;
            this.writeField(key, out, ff);
        }
        out.write("}\n");
    }

    private void writeField(String name, Writer out, FieldFormatter ff) throws IOException {
        Object o = this.getField(name);
        if (o != null) {
            out.write("  " + name + " = ");
            try {
                out.write(ff.format(o.toString(), GUIGlobals.isStandardField(name)));
            }
            catch (Throwable ex) {
                throw new IOException(Globals.lang("Error in field") + " '" + name + "': " + ex.getMessage());
            }
            out.write(",\n");
        }
    }

    public Object clone() {
        BibtexEntry clone = new BibtexEntry(this._id, this._type);
        clone._fields = (Map)((HashMap)this._fields).clone();
        return clone;
    }
}

