/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import org.ddogleg.struct.GrowQueue_I32;
import org.junit.Assert;
import org.junit.Test;

public class TestGrowQueue_I32 {
    @Test
    public void addAll_queue() {
        int i;
        GrowQueue_I32 queue0 = new GrowQueue_I32(2);
        GrowQueue_I32 queue1 = new GrowQueue_I32(3);
        queue0.add(1);
        queue0.add(2);
        queue1.add(3);
        queue1.add(4);
        queue1.add(5);
        Assert.assertEquals((long)2L, (long)queue0.size);
        queue0.addAll(queue1);
        Assert.assertEquals((long)5L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((long)queue0.get(i), (long)(i + 1));
        }
        queue0.reset();
        queue0.addAll(queue1);
        Assert.assertEquals((long)3L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((long)queue0.get(i), (long)(i + 3));
        }
    }

    @Test
    public void addAll_array() {
        int i;
        GrowQueue_I32 queue0 = new GrowQueue_I32(2);
        int[] array = new int[]{3, 4, 5};
        queue0.add(1);
        queue0.add(2);
        Assert.assertEquals((long)2L, (long)queue0.size);
        queue0.addAll(array, 0, 3);
        Assert.assertEquals((long)5L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((double)queue0.get(i), (double)(i + 1), (double)1.0E-8);
        }
        queue0.reset();
        queue0.addAll(array, 1, 3);
        Assert.assertEquals((long)2L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((double)queue0.get(i), (double)(i + 4), (double)1.0E-8);
        }
    }

    @Test
    public void auto_grow() {
        int i;
        GrowQueue_I32 alg = new GrowQueue_I32(3);
        Assert.assertEquals((long)3L, (long)alg.data.length);
        for (i = 0; i < 10; ++i) {
            alg.push(i);
        }
        Assert.assertEquals((long)10L, (long)alg.size);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)i, (double)alg.get(i), (double)1.0E-8);
        }
    }

    @Test
    public void reset() {
        GrowQueue_I32 alg = new GrowQueue_I32(10);
        alg.push(1);
        alg.push(3);
        alg.push(-2);
        Assert.assertTrue((1.0 == (double)alg.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)alg.size);
        alg.reset();
        Assert.assertEquals((long)0L, (long)alg.size);
    }

    @Test
    public void push_pop() {
        GrowQueue_I32 alg = new GrowQueue_I32(10);
        alg.push(1);
        alg.push(3);
        Assert.assertEquals((long)2L, (long)alg.size);
        Assert.assertTrue((3 == alg.pop() ? 1 : 0) != 0);
        Assert.assertTrue((1 == alg.pop() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)alg.size);
    }

    @Test
    public void remove() {
        GrowQueue_I32 alg = new GrowQueue_I32(10);
        alg.push(1);
        alg.push(3);
        alg.push(4);
        alg.push(5);
        alg.remove(1);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.get(0));
        Assert.assertEquals((long)4L, (long)alg.get(1));
        Assert.assertEquals((long)5L, (long)alg.get(2));
    }

    @Test
    public void insert() {
        GrowQueue_I32 alg = new GrowQueue_I32(10);
        alg.push(1);
        alg.push(3);
        alg.push(4);
        alg.push(5);
        alg.insert(2, 6);
        Assert.assertEquals((long)5L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.get(0));
        Assert.assertEquals((long)3L, (long)alg.get(1));
        Assert.assertEquals((long)6L, (long)alg.get(2));
        Assert.assertEquals((long)4L, (long)alg.get(3));
        Assert.assertEquals((long)5L, (long)alg.get(4));
        alg = new GrowQueue_I32(4);
        alg.push(1);
        alg.push(3);
        alg.push(4);
        alg.push(5);
        alg.insert(2, 6);
        Assert.assertEquals((long)5L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.get(0));
        Assert.assertEquals((long)3L, (long)alg.get(1));
        Assert.assertEquals((long)6L, (long)alg.get(2));
        Assert.assertEquals((long)4L, (long)alg.get(3));
        Assert.assertEquals((long)5L, (long)alg.get(4));
    }

    @Test
    public void removeHead() {
        GrowQueue_I32 alg = new GrowQueue_I32(10);
        alg.push(1);
        alg.push(3);
        alg.push(4);
        alg.push(5);
        alg.removeHead(0);
        Assert.assertEquals((long)4L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.get(0));
        alg.removeHead(2);
        Assert.assertEquals((long)2L, (long)alg.size);
        Assert.assertEquals((long)4L, (long)alg.get(0));
    }
}

