/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import org.ddogleg.struct.GrowQueue_F64;
import org.junit.Assert;
import org.junit.Test;

public class TestGrowQueue_F64 {
    @Test
    public void addAll_queue() {
        int i;
        GrowQueue_F64 queue0 = new GrowQueue_F64(2);
        GrowQueue_F64 queue1 = new GrowQueue_F64(3);
        queue0.add(1.0);
        queue0.add(2.0);
        queue1.add(3.0);
        queue1.add(4.0);
        queue1.add(5.0);
        Assert.assertEquals((long)2L, (long)queue0.size);
        queue0.addAll(queue1);
        Assert.assertEquals((long)5L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((double)queue0.get(i), (double)(i + 1), (double)1.0E-8);
        }
        queue0.reset();
        queue0.addAll(queue1);
        Assert.assertEquals((long)3L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((double)queue0.get(i), (double)(i + 3), (double)1.0E-8);
        }
    }

    @Test
    public void addAll_array() {
        int i;
        GrowQueue_F64 queue0 = new GrowQueue_F64(2);
        double[] array = new double[]{3.0, 4.0, 5.0};
        queue0.add(1.0);
        queue0.add(2.0);
        Assert.assertEquals((long)2L, (long)queue0.size);
        queue0.addAll(array, 0, 3);
        Assert.assertEquals((long)5L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((double)queue0.get(i), (double)(i + 1), (double)1.0E-8);
        }
        queue0.reset();
        queue0.addAll(array, 1, 3);
        Assert.assertEquals((long)2L, (long)queue0.size);
        for (i = 0; i < queue0.size; ++i) {
            Assert.assertEquals((double)queue0.get(i), (double)(i + 4), (double)1.0E-8);
        }
    }

    @Test
    public void auto_grow() {
        int i;
        GrowQueue_F64 alg = new GrowQueue_F64(3);
        Assert.assertEquals((long)3L, (long)alg.data.length);
        for (i = 0; i < 10; ++i) {
            alg.push(i);
        }
        Assert.assertEquals((long)10L, (long)alg.size);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)i, (double)alg.get(i), (double)1.0E-8);
        }
    }

    @Test
    public void reset() {
        GrowQueue_F64 alg = new GrowQueue_F64(10);
        alg.push(1.0);
        alg.push(3.0);
        alg.push(-2.0);
        Assert.assertTrue((1.0 == alg.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)alg.size);
        alg.reset();
        Assert.assertEquals((long)0L, (long)alg.size);
    }

    @Test
    public void push_pop() {
        GrowQueue_F64 alg = new GrowQueue_F64(10);
        alg.push(1.0);
        alg.push(3.0);
        Assert.assertEquals((long)2L, (long)alg.size);
        Assert.assertTrue((3.0 == alg.pop() ? 1 : 0) != 0);
        Assert.assertTrue((1.0 == alg.pop() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)alg.size);
    }

    @Test
    public void remove() {
        GrowQueue_F64 alg = new GrowQueue_F64(10);
        alg.push(1.0);
        alg.push(3.0);
        alg.push(4.0);
        alg.push(5.0);
        alg.remove(1);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertEquals((double)1.0, (double)alg.get(0), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)alg.get(1), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)alg.get(2), (double)1.0E-8);
    }

    @Test
    public void insert() {
        GrowQueue_F64 alg = new GrowQueue_F64(10);
        alg.push(1.0);
        alg.push(3.0);
        alg.push(4.0);
        alg.push(5.0);
        alg.insert(2, 6.0);
        Assert.assertEquals((double)5.0, (double)alg.size, (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)alg.get(0), (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)alg.get(1), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)alg.get(2), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)alg.get(3), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)alg.get(4), (double)1.0E-8);
        alg = new GrowQueue_F64(4);
        alg.push(1.0);
        alg.push(3.0);
        alg.push(4.0);
        alg.push(5.0);
        alg.insert(2, 6.0);
        Assert.assertEquals((long)5L, (long)alg.size);
        Assert.assertEquals((double)1.0, (double)alg.get(0), (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)alg.get(1), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)alg.get(2), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)alg.get(3), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)alg.get(4), (double)1.0E-8);
    }
}

