/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestFastQueueList {
    @Test
    public void size() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        List<Double> list = queue.toList();
        Assert.assertTrue((0 == list.size() ? 1 : 0) != 0);
        queue.add(1.0);
        Assert.assertTrue((1 == list.size() ? 1 : 0) != 0);
    }

    @Test
    public void isEmpty() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        List<Double> list = queue.toList();
        Assert.assertTrue((boolean)list.isEmpty());
        queue.add(1.0);
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void contains() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        Double d = 1.0;
        List<Double> list = queue.toList();
        Assert.assertFalse((boolean)list.contains(d));
        queue.add(d);
        Assert.assertTrue((boolean)list.contains(d));
    }

    @Test
    public void iterator() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        queue.add(1.0);
        queue.add(2.0);
        queue.add(3.0);
        Iterator<Double> iterator = queue.toList().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((1.0 == iterator.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((2.0 == iterator.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((3.0 == iterator.next() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void toArray() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        queue.add(1.0);
        queue.add(2.0);
        queue.add(3.0);
        Object[] array = queue.toList().toArray();
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertTrue((1.0 == (Double)array[0] ? 1 : 0) != 0);
        Assert.assertTrue((2.0 == (Double)array[1] ? 1 : 0) != 0);
        Assert.assertTrue((3.0 == (Double)array[2] ? 1 : 0) != 0);
        queue.removeTail();
        array = queue.toList().toArray();
        Assert.assertEquals((long)2L, (long)array.length);
    }

    @Test
    public void add() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        List<Double> list = queue.toList();
        list.add(5.0);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((double)5.0, (double)queue.get(0), (double)1.0E-8);
    }

    @Test
    public void containsAll() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        queue.add(1.0);
        queue.add(2.0);
        queue.add(3.0);
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(1.0);
        list.add(2.0);
        Assert.assertTrue((boolean)queue.toList().containsAll(list));
        list.add(5.0);
        Assert.assertFalse((boolean)queue.toList().containsAll(list));
    }

    @Test
    public void addAll() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        List<Double> list = queue.toList();
        ArrayList<Double> stuff = new ArrayList<Double>();
        stuff.add(5.0);
        stuff.add(10.0);
        Assert.assertTrue((boolean)list.addAll(stuff));
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertEquals((double)5.0, (double)queue.get(0), (double)1.0E-8);
        Assert.assertEquals((double)10.0, (double)queue.get(1), (double)1.0E-8);
    }

    @Test
    public void get() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        queue.add(1.0);
        queue.add(2.0);
        Assert.assertTrue((2.0 == queue.toList().get(1) ? 1 : 0) != 0);
    }

    @Test
    public void set() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        queue.add(1.0);
        queue.add(2.0);
        List<Double> list = queue.toList();
        list.set(0, 3.0);
        Assert.assertTrue((3.0 == list.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void indexOf_lastIndexOf() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        queue.add(1.0);
        queue.add(2.0);
        queue.add(2.0);
        queue.add(3.0);
        Assert.assertTrue((1 == queue.toList().indexOf(2.0) ? 1 : 0) != 0);
        Assert.assertTrue((2 == queue.toList().lastIndexOf(2.0) ? 1 : 0) != 0);
    }
}

