/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import org.ddogleg.struct.CircularQueue_I32;
import org.junit.Assert;
import org.junit.Test;

public class TestCircularQueue_I32 {
    @Test
    public void popHead() {
        CircularQueue_I32 alg = new CircularQueue_I32();
        alg.add(1);
        alg.add(2);
        Assert.assertEquals((long)1L, (long)alg.popHead());
        Assert.assertEquals((long)1L, (long)alg.size());
        Assert.assertEquals((long)2L, (long)alg.popHead());
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void popTail() {
        CircularQueue_I32 alg = new CircularQueue_I32();
        alg.add(1);
        alg.add(2);
        Assert.assertEquals((long)2L, (long)alg.popTail());
        Assert.assertEquals((long)1L, (long)alg.size());
        Assert.assertEquals((long)1L, (long)alg.popTail());
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void head() {
        CircularQueue_I32 alg = new CircularQueue_I32();
        alg.add(1);
        Assert.assertEquals((long)1L, (long)alg.head());
        alg.add(3);
        Assert.assertEquals((long)1L, (long)alg.head());
    }

    @Test
    public void head_offset() {
        CircularQueue_I32 alg = new CircularQueue_I32(3);
        alg.start = 2;
        alg.size = 0;
        alg.add(1);
        Assert.assertEquals((long)1L, (long)alg.head());
        alg.add(3);
        Assert.assertEquals((long)1L, (long)alg.head());
    }

    @Test
    public void tail() {
        CircularQueue_I32 alg = new CircularQueue_I32();
        alg.add(1);
        Assert.assertEquals((long)1L, (long)alg.tail());
        alg.add(3);
        Assert.assertEquals((long)3L, (long)alg.tail());
    }

    @Test
    public void tail_offset() {
        CircularQueue_I32 alg = new CircularQueue_I32(3);
        alg.start = 2;
        alg.size = 0;
        alg.add(1);
        Assert.assertEquals((long)1L, (long)alg.tail());
        alg.add(3);
        Assert.assertEquals((long)3L, (long)alg.tail());
    }

    @Test
    public void removeHead() {
        CircularQueue_I32 alg = new CircularQueue_I32();
        alg.add(1);
        alg.add(2);
        alg.removeHead();
        Assert.assertEquals((long)2L, (long)alg.head());
        Assert.assertEquals((long)1L, (long)alg.size());
        alg.removeHead();
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void removeTail() {
        CircularQueue_I32 alg = new CircularQueue_I32();
        alg.add(1);
        alg.add(2);
        alg.removeTail();
        Assert.assertEquals((long)1L, (long)alg.head());
        Assert.assertEquals((long)1L, (long)alg.size());
        alg.removeTail();
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void get() {
        CircularQueue_I32 alg = new CircularQueue_I32(2);
        Assert.assertEquals((long)2L, (long)alg.data.length);
        alg.add(1);
        alg.add(2);
        Assert.assertEquals((long)1L, (long)alg.get(0));
        Assert.assertEquals((long)2L, (long)alg.get(1));
        alg.removeHead();
        alg.add(3);
        Assert.assertEquals((long)2L, (long)alg.data.length);
        Assert.assertEquals((long)2L, (long)alg.get(0));
        Assert.assertEquals((long)3L, (long)alg.get(1));
    }

    @Test
    public void add() {
        CircularQueue_I32 alg = new CircularQueue_I32(3);
        Assert.assertEquals((long)3L, (long)alg.data.length);
        alg.add(1);
        Assert.assertEquals((long)1L, (long)alg.data[0]);
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.add(2);
        Assert.assertEquals((long)1L, (long)alg.data[0]);
        Assert.assertEquals((long)2L, (long)alg.data[1]);
        Assert.assertEquals((long)2L, (long)alg.size);
        alg.add(3);
        alg.add(4);
        Assert.assertEquals((long)1L, (long)alg.data[0]);
        Assert.assertEquals((long)2L, (long)alg.data[1]);
        Assert.assertEquals((long)3L, (long)alg.data[2]);
        Assert.assertEquals((long)4L, (long)alg.data[3]);
        Assert.assertEquals((long)4L, (long)alg.size);
        alg.start = 1;
        alg.data = new int[]{1, 2, 3};
        alg.size = 3;
        alg.add(4);
        Assert.assertEquals((long)2L, (long)alg.data[0]);
        Assert.assertEquals((long)3L, (long)alg.data[1]);
        Assert.assertEquals((long)1L, (long)alg.data[2]);
        Assert.assertEquals((long)4L, (long)alg.data[3]);
        Assert.assertEquals((long)4L, (long)alg.size);
        alg.start = 1;
        alg.size = 2;
        alg.data = new int[3];
        alg.add(10);
        Assert.assertEquals((long)10L, (long)alg.data[0]);
        Assert.assertEquals((long)10L, (long)alg.data[0]);
        Assert.assertEquals((long)3L, (long)alg.size);
    }

    @Test
    public void addW() {
        CircularQueue_I32 alg = new CircularQueue_I32(3);
        Assert.assertEquals((long)3L, (long)alg.data.length);
        alg.addW(1);
        Assert.assertEquals((long)1L, (long)alg.data[0]);
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.addW(2);
        Assert.assertEquals((long)1L, (long)alg.data[0]);
        Assert.assertEquals((long)2L, (long)alg.data[1]);
        Assert.assertEquals((long)2L, (long)alg.size);
        alg.addW(3);
        alg.addW(4);
        Assert.assertEquals((long)4L, (long)alg.data[0]);
        Assert.assertEquals((long)2L, (long)alg.data[1]);
        Assert.assertEquals((long)3L, (long)alg.data[2]);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.start);
        alg.start = 1;
        alg.size = 2;
        alg.data = new int[3];
        alg.addW(10);
        Assert.assertEquals((long)10L, (long)alg.data[0]);
        Assert.assertEquals((long)3L, (long)alg.size);
    }

    @Test
    public void isEmpty() {
        CircularQueue_I32 alg = new CircularQueue_I32(3);
        Assert.assertTrue((boolean)alg.isEmpty());
        alg.add(5);
        Assert.assertFalse((boolean)alg.isEmpty());
        alg.removeTail();
        Assert.assertTrue((boolean)alg.isEmpty());
    }

    @Test
    public void reset() {
        CircularQueue_I32 alg = new CircularQueue_I32(3);
        alg.start = 2;
        alg.size = 5;
        alg.reset();
        Assert.assertEquals((long)0L, (long)alg.size);
        Assert.assertEquals((long)0L, (long)alg.start);
    }
}

