/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Stack;

public class RecycleManager<T> {
    protected Class<T> targetClass;
    protected Stack<T> unused = new Stack();

    public RecycleManager(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    protected RecycleManager() {
    }

    public T requestInstance() {
        T a = this.unused.size() > 0 ? this.unused.pop() : this.createInstance();
        return a;
    }

    public void recycleInstance(T object) {
        this.unused.add(object);
    }

    protected T createInstance() {
        try {
            return this.targetClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Stack<T> getUnused() {
        return this.unused;
    }
}

