/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;

public class GrowQueue_B {
    public boolean[] data;
    public int size;

    public GrowQueue_B(int maxSize) {
        this.data = new boolean[maxSize];
        this.size = 0;
    }

    public GrowQueue_B() {
        this(10);
    }

    public void reset() {
        this.size = 0;
    }

    public void add(boolean value) {
        this.push(value);
    }

    public void push(boolean val) {
        if (this.size == this.data.length) {
            boolean[] temp = new boolean[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public boolean unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, boolean value) {
        this.data[index] = value;
    }

    public void setTo(GrowQueue_B original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void fill(boolean value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void insert(int index, boolean value) {
        if (this.size == this.data.length) {
            boolean[] temp = new boolean[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public boolean removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new boolean[size];
        }
        this.size = size;
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new boolean[size];
        }
    }

    public int size() {
        return this.size;
    }

    public boolean pop() {
        return this.data[--this.size];
    }
}

