/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.stats;

import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.GrowQueue_F64;

public class UtilStatisticsQueue {
    public static double mean(GrowQueue_F64 list) {
        double total = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            total += list.data[i];
        }
        return total / (double)list.size();
    }

    public static double variance(GrowQueue_F64 list, double mean) {
        double total = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d = list.data[i] - mean;
            total += d * d;
        }
        return total / (double)(list.size() - 1);
    }

    public static double stdev(GrowQueue_F64 list, double mean) {
        return Math.sqrt(UtilStatisticsQueue.variance(list, mean));
    }

    public static double fraction(GrowQueue_F64 list, double fraction) {
        int k = (int)((double)(list.size - 1) * fraction + 0.5);
        return QuickSelect.select(list.data, k, list.size);
    }
}

