/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.BenchMarkSort;
import org.ddogleg.sorting.QuickSort_S32;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSort_S32 {
    Random rand = new Random(1044180L);

    @Test
    public void testSortingRandom() {
        int[] ret = BenchMarkSort.createRandom_S32(this.rand, 200);
        int preTotal = this.sum(ret);
        QuickSort_S32 sorter = new QuickSort_S32();
        sorter.sort(ret, ret.length);
        int postTotal = this.sum(ret);
        Assert.assertEquals((double)preTotal, (double)postTotal, (double)1.0E-8);
        double prev = ret[0];
        for (int i = 1; i < ret.length; ++i) {
            if ((double)ret[i] < prev) {
                Assert.fail((String)"Not ascending");
            }
            prev = ret[i];
        }
    }

    private int sum(int[] a) {
        int total = 0;
        for (int i = 0; i < a.length; ++i) {
            total += a[i];
        }
        return total;
    }

    @Test
    public void testSortingRandom_indexes() {
        for (int a = 0; a < 20; ++a) {
            int[] normal = BenchMarkSort.createRandom_S32(this.rand, 20);
            int[] original = (int[])normal.clone();
            int[] withIndexes = (int[])normal.clone();
            int[] indexes = new int[normal.length];
            QuickSort_S32 sorter = new QuickSort_S32();
            sorter.sort(normal, normal.length);
            sorter.sort(withIndexes, normal.length, indexes);
            for (int i = 0; i < normal.length; ++i) {
                Assert.assertEquals((double)original[i], (double)withIndexes[i], (double)1.0E-8);
                Assert.assertEquals((double)normal[i], (double)withIndexes[indexes[i]], (double)1.0E-8);
            }
        }
    }
}

