/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.QuickSortObj_F64;
import org.ddogleg.sorting.SortableParameter_F64;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSortObj_F64 {
    Random rand = new Random(1044180L);

    @Test
    public void testSortingRandom() {
        SortableParameter_F64[] ret = TestQuickSortObj_F64.createRandom(this.rand, 200);
        double preTotal = TestQuickSortObj_F64.sum(ret);
        QuickSortObj_F64 sorter = new QuickSortObj_F64();
        sorter.sort(ret, ret.length);
        double postTotal = TestQuickSortObj_F64.sum(ret);
        Assert.assertEquals((double)preTotal, (double)postTotal, (double)0.01);
        SortableParameter_F64 prev = ret[0];
        for (int i = 1; i < ret.length; ++i) {
            if (ret[i].sortValue < prev.sortValue) {
                Assert.fail((String)"Not ascending");
            }
            prev = ret[i];
        }
    }

    @Test
    public void testSortingRandom_indexes() {
        for (int a = 0; a < 20; ++a) {
            SortableParameter_F64[] normal = TestQuickSortObj_F64.createRandom(this.rand, 20);
            SortableParameter_F64[] original = TestQuickSortObj_F64.copy(normal);
            SortableParameter_F64[] withIndexes = TestQuickSortObj_F64.copy(normal);
            int[] indexes = new int[normal.length];
            QuickSortObj_F64 sorter = new QuickSortObj_F64();
            sorter.sort(normal, normal.length);
            sorter.sort(withIndexes, normal.length, indexes);
            for (int i = 0; i < normal.length; ++i) {
                Assert.assertEquals((double)original[i].sortValue, (double)withIndexes[i].sortValue, (double)1.0E-8);
                Assert.assertEquals((double)normal[i].sortValue, (double)withIndexes[indexes[i]].sortValue, (double)1.0E-8);
            }
        }
    }

    public static SortableParameter_F64[] copy(SortableParameter_F64[] list) {
        SortableParameter_F64[] ret = new SortableParameter_F64[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = new SortableParameter_F64();
            ret[i].sortValue = list[i].sortValue;
        }
        return ret;
    }

    public static double sum(SortableParameter_F64[] list) {
        double total = 0.0;
        for (int i = 0; i < list.length; ++i) {
            total += list[i].sortValue;
        }
        return total;
    }

    public static SortableParameter_F64[] createRandom(Random rand, int num) {
        SortableParameter_F64[] ret = new SortableParameter_F64[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = new SortableParameter_F64();
            ret[i].sortValue = (rand.nextDouble() - 0.5) * 2000.0;
        }
        return ret;
    }
}

