/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.QuickSortObj_F32;
import org.ddogleg.sorting.SortableParameter_F32;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSortObj_F32 {
    Random rand = new Random(1044180L);

    @Test
    public void testSortingRandom() {
        SortableParameter_F32[] ret = TestQuickSortObj_F32.createRandom(this.rand, 200);
        float preTotal = TestQuickSortObj_F32.sum(ret);
        QuickSortObj_F32 sorter = new QuickSortObj_F32();
        sorter.sort(ret, ret.length);
        float postTotal = TestQuickSortObj_F32.sum(ret);
        Assert.assertEquals((double)preTotal, (double)postTotal, (double)0.01);
        SortableParameter_F32 prev = ret[0];
        for (int i = 1; i < ret.length; ++i) {
            if (ret[i].sortValue < prev.sortValue) {
                Assert.fail((String)"Not ascending");
            }
            prev = ret[i];
        }
    }

    @Test
    public void testSortingRandom_indexes() {
        for (int a = 0; a < 20; ++a) {
            SortableParameter_F32[] normal = TestQuickSortObj_F32.createRandom(this.rand, 20);
            SortableParameter_F32[] original = TestQuickSortObj_F32.copy(normal);
            SortableParameter_F32[] withIndexes = TestQuickSortObj_F32.copy(normal);
            int[] indexes = new int[normal.length];
            QuickSortObj_F32 sorter = new QuickSortObj_F32();
            sorter.sort(normal, normal.length);
            sorter.sort(withIndexes, normal.length, indexes);
            for (int i = 0; i < normal.length; ++i) {
                Assert.assertEquals((double)original[i].sortValue, (double)withIndexes[i].sortValue, (double)1.0E-4);
                Assert.assertEquals((double)normal[i].sortValue, (double)withIndexes[indexes[i]].sortValue, (double)1.0E-4);
            }
        }
    }

    public static SortableParameter_F32[] copy(SortableParameter_F32[] list) {
        SortableParameter_F32[] ret = new SortableParameter_F32[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = new SortableParameter_F32();
            ret[i].sortValue = list[i].sortValue;
        }
        return ret;
    }

    public static float sum(SortableParameter_F32[] list) {
        float total = 0.0f;
        for (int i = 0; i < list.length; ++i) {
            total += list[i].sortValue;
        }
        return total;
    }

    public static SortableParameter_F32[] createRandom(Random rand, int num) {
        SortableParameter_F32[] ret = new SortableParameter_F32[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = new SortableParameter_F32();
            ret[i].sortValue = (rand.nextFloat() - 0.5f) * 2000.0f;
        }
        return ret;
    }
}

