/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Arrays;
import org.ddogleg.sorting.CountingSort;
import org.junit.Assert;
import org.junit.Test;

public class TestCountingSort {
    @Test
    public void sort_inplace() {
        int[] a = new int[]{66, 4, 2, 9, 5, 4, 5, 72, 20, 4, 56, 94, 53, 2, 55, 5, 5, 5, 5, 5, 7, 89, 4, 3, 2};
        int[] copy = (int[])a.clone();
        Arrays.sort(copy);
        CountingSort alg = new CountingSort(0, 100);
        alg.sort(a, 0, a.length);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((long)copy[i], (long)a[i]);
        }
    }

    @Test
    public void sort_in_out() {
        int[] a = new int[]{66, 4, 2, 9, 5, 4, 5, 72, 20, 4, 56, 94, 53, 2, 55, 5, 5, 5, 5, 5, 7, 89, 4, 3, 2};
        int[] b = new int[a.length];
        int[] copy = (int[])a.clone();
        Arrays.sort(copy);
        CountingSort alg = new CountingSort(0, 100);
        alg.sort(a, 0, b, 0, a.length);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((long)copy[i], (long)b[i]);
        }
    }

    @Test
    public void sortIndex() {
        int[] a = new int[]{123, 66, 4, 2, 9, 5, 4, 5, 72, 20, 4, 56, 94, 53, 2, 55, 5, 5, 5, 5, 5, 7, 89, 4, 3, 2};
        int[] indexes = new int[a.length - 1];
        int[] copy = (int[])a.clone();
        Arrays.sort(copy, 1, a.length);
        CountingSort alg = new CountingSort(0, 100);
        alg.sortIndex(a, 1, indexes.length, indexes);
        for (int i = 0; i < indexes.length; ++i) {
            Assert.assertEquals((long)copy[i + 1], (long)a[indexes[i]]);
        }
    }
}

