/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver.impl;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.impl.FindRealRootsSturm;
import org.ejml.data.Complex64F;

public class WrapRealRootsSturm
implements PolynomialRoots {
    FindRealRootsSturm alg;
    List<Complex64F> roots = new ArrayList<Complex64F>();
    Complex64F[] storage;

    public WrapRealRootsSturm(FindRealRootsSturm alg) {
        this.alg = alg;
        this.storage = new Complex64F[alg.getMaxRoots()];
        for (int i = 0; i < this.storage.length; ++i) {
            this.storage[i] = new Complex64F();
        }
    }

    @Override
    public boolean process(Polynomial poly) {
        try {
            this.alg.process(poly);
        }
        catch (RuntimeException e) {
            return false;
        }
        this.roots.clear();
        double[] found = this.alg.getRoots();
        int N = this.alg.getNumberOfRoots();
        for (int i = 0; i < N; ++i) {
            Complex64F c = this.storage[i];
            c.real = found[i];
            c.imaginary = 0.0;
            this.roots.add(c);
        }
        return true;
    }

    @Override
    public List<Complex64F> getRoots() {
        return this.roots;
    }
}

