/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver.impl;

import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;

public class SturmSequence {
    protected Polynomial next;
    protected Polynomial previous;
    protected Polynomial result;
    protected Polynomial[] sequence;
    protected int sequenceLength;
    protected double[] f;

    public SturmSequence(int maxPolySize) {
        this.next = new Polynomial(maxPolySize);
        this.previous = new Polynomial(maxPolySize);
        this.result = new Polynomial(maxPolySize);
        this.sequence = new Polynomial[maxPolySize + 1];
        for (int i = 0; i < this.sequence.length; ++i) {
            this.sequence[i] = new Polynomial(maxPolySize);
        }
        this.f = new double[maxPolySize + 1];
    }

    public void initialize(Polynomial poly) {
        this.sequence[0].setTo(poly);
        if (poly.size <= 1) {
            this.sequenceLength = 1;
            return;
        }
        PolynomialOps.derivative(poly, this.previous);
        PolynomialOps.divide(this.sequence[0], this.previous, this.result, this.next);
        this.negative(this.next);
        if (poly.size == 2) {
            this.sequence[1].setTo(this.previous);
            this.sequenceLength = 2;
            return;
        }
        for (int i = 2; i < poly.size && this.next.size > 0; ++i) {
            PolynomialOps.divide(this.previous, this.next, this.sequence[i - 1], this.result);
            this.negative(this.result);
            int degree = this.result.computeDegree();
            if (degree <= 0) {
                if (degree < 0) {
                    this.sequence[i].setTo(this.next);
                    this.sequenceLength = i + 1;
                    break;
                }
                this.sequence[i + 1].setTo(this.result);
                PolynomialOps.divide(this.next, this.result, this.sequence[i], this.previous);
                this.sequenceLength = i + 2;
                break;
            }
            Polynomial temp = this.previous;
            this.previous = this.next;
            this.next = this.result;
            this.result = temp;
        }
    }

    public int countRealRoots(double lower, double upper) {
        if (this.sequenceLength <= 1) {
            return 0;
        }
        this.computeFunctions(lower);
        int numLow = this.countSignChanges();
        this.computeFunctions(upper);
        int numHigh = this.countSignChanges();
        return numLow - numHigh;
    }

    private void negative(Polynomial p) {
        for (int j = 0; j < p.size; ++j) {
            p.c[j] = -p.c[j];
        }
    }

    protected int countSignChanges() {
        int i;
        for (i = 0; i < this.sequenceLength && this.f[i] == 0.0; ++i) {
        }
        if (i == this.sequenceLength) {
            return 0;
        }
        int signChanges = 0;
        boolean isPlus = this.f[i] > 0.0;
        ++i;
        while (i < this.sequenceLength) {
            double v = this.f[i];
            if (isPlus) {
                if (v < 0.0) {
                    isPlus = false;
                    ++signChanges;
                }
            } else if (v > 0.0) {
                isPlus = true;
                ++signChanges;
            }
            ++i;
        }
        return signChanges;
    }

    protected void computeFunctions(double value) {
        this.f[this.sequenceLength - 1] = this.sequence[this.sequenceLength - 1].c[0];
        if (Double.isInfinite(value)) {
            this.f[this.sequenceLength - 2] = this.multiplyInfinity(this.sequence[this.sequenceLength - 2].evaluate(value), this.f[this.sequenceLength - 1]);
            for (int i = this.sequenceLength - 3; i > 0; --i) {
                this.f[i] = this.multiplyInfinity(this.sequence[i].evaluate(value), this.f[i + 1]);
            }
        } else {
            this.f[this.sequenceLength - 2] = this.sequence[this.sequenceLength - 2].evaluate(value) * this.f[this.sequenceLength - 1];
            for (int i = this.sequenceLength - 3; i > 0; --i) {
                this.f[i] = this.sequence[i].evaluate(value) * this.f[i + 1] - this.f[i + 2];
            }
        }
        this.f[0] = this.sequence[0].evaluate(value);
    }

    private double multiplyInfinity(double a, double b) {
        int signB;
        int signA = this.sign(a);
        int s = signA * (signB = this.sign(b));
        if (s == 0) {
            return 0.0;
        }
        if (s == -1) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }

    private int sign(double a) {
        if (Double.isInfinite(a)) {
            if (a == Double.POSITIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (a > 0.0) {
            return 1;
        }
        if (a < 0.0) {
            return -1;
        }
        return 0;
    }
}

