/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.impl.NumericalGradientForward;
import org.ddogleg.optimization.wrap.LsToNonLinear;
import org.ddogleg.optimization.wrap.LsToNonLinearDeriv;
import org.junit.Assert;
import org.junit.Test;

public class TestLsToNonLinearDeriv {
    @Test
    public void compareToNumeric() {
        FuncLS funcLS = new FuncLS();
        DerivLS derivLS = new DerivLS();
        LsToNonLinear func = new LsToNonLinear(funcLS);
        LsToNonLinearDeriv deriv = new LsToNonLinearDeriv(funcLS, derivLS);
        NumericalGradientForward derivNumeric = new NumericalGradientForward(func);
        double[] point = new double[]{1.0, 2.0};
        double[] expected = new double[2];
        double[] found = new double[2];
        deriv.process(point, found);
        derivNumeric.process(point, expected);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)found[i], (double)1.0E-4);
        }
    }

    public static class DerivLS
    implements FunctionNtoMxN {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return 3;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            output[0] = 1.0;
            output[1] = 20.0 * x2;
            output[2] = 0.0;
            output[3] = 1.0;
            output[4] = 2.0;
            output[5] = 1.0;
        }
    }

    public static class FuncLS
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return 3;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            output[0] = x1 + 10.0 * x2 * x2;
            output[1] = x2;
            output[2] = 2.0 * x1 + x2;
        }
    }
}

