/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.CallCounterNtoS;
import org.ddogleg.optimization.impl.NumericalGradientForward;
import org.ddogleg.optimization.impl.TrivialFunctionNtoS;
import org.ddogleg.optimization.wrap.CachedNumericalGradientLineFunction;
import org.junit.Assert;
import org.junit.Test;

public class TestCachedNumericalGradientLineFunction {
    @Test
    public void testSetInput_vector() {
        CallCounterNtoS func = new CallCounterNtoS(new TrivialFunctionNtoS());
        NumericalGradientForward gradient = new NumericalGradientForward(new TrivialFunctionNtoS());
        CachedNumericalGradientLineFunction alg = new CachedNumericalGradientLineFunction(func);
        double[] x = new double[]{1.0, 2.0, 3.0};
        alg.setInput(x);
        Assert.assertEquals((long)0L, (long)func.count);
        double[] foundG = new double[x.length];
        double[] expectedG = new double[x.length];
        alg.computeFunction();
        alg.computeFunction();
        alg.computeGradient(foundG);
        alg.computeGradient(foundG);
        Assert.assertEquals((long)5L, (long)func.count);
        x = new double[]{2.0, 3.0, 1.0};
        alg.setInput(x);
        double foundF = alg.computeFunction();
        alg.computeGradient(foundG);
        Assert.assertEquals((long)10L, (long)func.count);
        gradient.process(x, expectedG);
        Assert.assertEquals((double)func.process(x), (double)foundF, (double)1.0E-8);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((double)expectedG[i], (double)foundG[i], (double)1.0E-8);
        }
    }

    @Test
    public void testSetInput_step() {
        CallCounterNtoS func = new CallCounterNtoS(new TrivialFunctionNtoS());
        CachedNumericalGradientLineFunction alg = new CachedNumericalGradientLineFunction(func);
        double[] x = new double[]{1.0, 2.0, 3.0};
        double[] d = new double[]{1.0, 1.0, 1.0};
        alg.setLine(x, d);
        alg.setInput(1.0);
        Assert.assertEquals((long)0L, (long)func.count);
        double[] foundG = new double[x.length];
        alg.computeFunction();
        alg.computeFunction();
        alg.computeGradient(foundG);
        alg.computeGradient(foundG);
        alg.computeDerivative();
        alg.computeDerivative();
        Assert.assertEquals((long)7L, (long)func.count);
        alg.setInput(2.0);
        double foundF = alg.computeFunction();
        alg.computeDerivative();
        Assert.assertEquals((long)10L, (long)func.count);
        x = new double[]{3.0, 4.0, 5.0};
        Assert.assertEquals((double)func.process(x), (double)foundF, (double)1.0E-8);
    }
}

