/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.impl.NumericalJacobianForward;
import org.ddogleg.optimization.impl.TrivialLeastSquaresResidual;
import org.junit.Assert;
import org.junit.Test;

public abstract class GenericUnconstrainedLeastSquaresTests {
    public abstract UnconstrainedLeastSquares createAlgorithm();

    @Test
    public void basicTest() {
        double[] found;
        int i;
        double a = 2.0;
        double b = 0.1;
        TrivialLeastSquaresResidual residual = new TrivialLeastSquaresResidual(a, b);
        NumericalJacobianForward jacobian = new NumericalJacobianForward(residual);
        UnconstrainedLeastSquares alg = this.createAlgorithm();
        alg.setFunction(residual, jacobian);
        alg.initialize(new double[]{1.0, 0.5}, 1.0E-10, 1.0E-10);
        double[] prev = new double[]{1.0, 0.5};
        for (i = 0; i < 200 && !alg.iterate(); ++i) {
            found = alg.getParameters();
            if (alg.isUpdated()) {
                boolean changed = false;
                for (int j = 0; j < found.length; ++j) {
                    if (found[j] == prev[j]) continue;
                    changed = true;
                }
                Assert.assertTrue((boolean)changed);
            } else {
                for (int j = 0; j < found.length; ++j) {
                    Assert.assertTrue((found[j] == prev[j] ? 1 : 0) != 0);
                }
            }
            prev = (double[])found.clone();
        }
        Assert.assertTrue((i != 200 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alg.isConverged());
        found = alg.getParameters();
        Assert.assertEquals((double)a, (double)found[0], (double)1.0E-4);
        Assert.assertEquals((double)b, (double)found[1], (double)1.0E-4);
    }

    @Test
    public void checkNumerical() {
        double a = 2.0;
        double b = 0.1;
        TrivialLeastSquaresResidual residual = new TrivialLeastSquaresResidual(a, b);
        NumericalJacobianForward jacobian = new NumericalJacobianForward(residual);
        UnconstrainedLeastSquares alg = this.createAlgorithm();
        alg.setFunction(residual, jacobian);
        alg.initialize(new double[]{1.0, 0.5}, 1.0E-10, 1.0E-10);
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        double[] expected = (double[])alg.getParameters().clone();
        alg.setFunction(residual, null);
        alg.initialize(new double[]{1.0, 0.5}, 1.0E-10, 1.0E-10);
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        double[] found = (double[])alg.getParameters().clone();
        for (int i = 0; i < found.length; ++i) {
            Assert.assertTrue((found[i] == expected[i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAcceptModified() {
        ModifyInputFunctions residuals = new ModifyInputFunctions();
        UnconstrainedLeastSquares alg = this.createAlgorithm();
        alg.setFunction(residuals, null);
        alg.initialize(new double[]{1.0, 0.5, 9.5}, 1.0E-10, 1.0E-10);
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        double[] found = (double[])alg.getParameters().clone();
        double[] expected = new double[]{1.0, 2.0, 3.0};
        for (int i = 0; i < found.length; ++i) {
            Assert.assertTrue((found[i] == expected[i] ? 1 : 0) != 0);
        }
    }

    private class ModifyInputFunctions
    implements FunctionNtoM {
        private ModifyInputFunctions() {
        }

        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public int getNumOfOutputsM() {
            return 2;
        }

        @Override
        public void process(double[] input, double[] output) {
            int i;
            for (i = 0; i < input.length; ++i) {
                input[i] = 1 + i;
            }
            for (i = 0; i < output.length; ++i) {
                output[i] = 0.0;
            }
        }
    }
}

