/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.CauchyStep;
import org.ddogleg.optimization.impl.DoglegStepF;
import org.ddogleg.optimization.impl.DoglegStepFtF;
import org.ddogleg.optimization.impl.NumericalJacobianForward;
import org.ddogleg.optimization.impl.TrivialLeastSquaresResidual;
import org.ddogleg.optimization.impl.TrustRegionLeastSquares;
import org.ddogleg.optimization.impl.TrustRegionStep;
import org.ddogleg.optimization.wrap.Individual_to_CoupledJacobian;
import org.ejml.data.DenseMatrix64F;
import org.junit.Assert;
import org.junit.Test;

public class TestTrustRegionLeastSquares {
    @Test
    public void perfectInitial() {
        double a = 2.0;
        double b = 0.1;
        TrustRegionLeastSquares alg = this.createAlg(a, b, new DummyStep());
        alg.initialize(new double[]{2.0, 0.1});
        Assert.assertTrue((boolean)alg.iterate());
        double[] found = alg.getParameters();
        Assert.assertEquals((double)a, (double)found[0], (double)1.0E-4);
        Assert.assertEquals((double)b, (double)found[1], (double)1.0E-4);
    }

    private TrustRegionLeastSquares createAlg(double a, double b, TrustRegionStep stepAlg) {
        TrivialLeastSquaresResidual residual = new TrivialLeastSquaresResidual(a, b);
        NumericalJacobianForward jacobian = new NumericalJacobianForward(residual);
        TrustRegionLeastSquares alg = new TrustRegionLeastSquares(2.0, stepAlg);
        alg.setConvergence(1.0E-6, 1.0E-6);
        alg.setFunction(new Individual_to_CoupledJacobian(residual, jacobian));
        return alg;
    }

    @Test
    public void basicTest_Cauchy() {
        this.basicTest(new CauchyStep());
    }

    @Test
    public void basicTest_DoglegFtF() {
        this.basicTest(new DoglegStepFtF());
    }

    @Test
    public void basicTest_DoglegF() {
        this.basicTest(new DoglegStepF());
    }

    protected void basicTest(TrustRegionStep step) {
        int i;
        double a = 2.0;
        double b = 0.1;
        TrustRegionLeastSquares alg = this.createAlg(a, b, step);
        alg.initialize(new double[]{1.0, 0.5});
        alg.setConvergence(1.0E-8, 1.0E-8);
        for (i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        Assert.assertTrue((i != 200 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alg.isConverged());
        double[] found = alg.getParameters();
        Assert.assertEquals((double)a, (double)found[0], (double)1.0E-4);
        Assert.assertEquals((double)b, (double)found[1], (double)1.0E-4);
    }

    static class DummyStep
    implements TrustRegionStep {
        DummyStep() {
        }

        @Override
        public void init(int numParam, int numFunctions) {
        }

        @Override
        public void setInputs(DenseMatrix64F x, DenseMatrix64F residuals, DenseMatrix64F J, DenseMatrix64F gradient, double fx) {
        }

        @Override
        public void computeStep(double regionRadius, DenseMatrix64F step) {
        }

        @Override
        public double predictedReduction() {
            return 0.0;
        }

        @Override
        public boolean isMaxStep() {
            return false;
        }
    }
}

