/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import java.util.List;
import org.ddogleg.optimization.EvaluateLineSearchFletcher86;
import org.ddogleg.optimization.LineSearchEvaluator;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.impl.LineSearchFletcher86;
import org.ddogleg.optimization.impl.TestLineSearchMore94;
import org.ddogleg.optimization.impl.TrivialQuadraticDerivStoS;
import org.ddogleg.optimization.impl.TrivialQuadraticStoS;
import org.ddogleg.optimization.wrap.Individual_to_CoupledDerivative;
import org.junit.Assert;
import org.junit.Test;

public class TestLineSearchFletcher86 {
    EvaluateLineSearchFletcher86 eval = new EvaluateLineSearchFletcher86(false);

    @Test
    public void checkBasic() {
        double expected = 10.0;
        TrivialQuadraticStoS f = new TrivialQuadraticStoS(expected);
        TrivialQuadraticDerivStoS d = new TrivialQuadraticDerivStoS(expected);
        LineSearchFletcher86 alg = new LineSearchFletcher86(0.1, 0.9, 0.0, 9.0, 0.1, 0.5);
        alg.setFunction(new Individual_to_CoupledDerivative(f, d));
        double valueZero = f.process(0.0);
        double derivZero = d.process(0.0);
        double initValue = f.process(1.0);
        alg.init(valueZero, derivZero, initValue, 1.0, 0.0, 100.0);
        Assert.assertTrue((boolean)UtilOptimize.process(alg, 50));
        double foundLoose = alg.getStep();
        alg = new LineSearchFletcher86(1.0E-5, 0.1, 0.0, 9.0, 0.05, 0.5);
        alg.setFunction(new Individual_to_CoupledDerivative(f, d));
        alg.init(valueZero, derivZero, initValue, 1.0, 0.0, 100.0);
        Assert.assertTrue((boolean)UtilOptimize.process(alg, 50));
        double foundTight = alg.getStep();
        Assert.assertTrue((Math.abs(foundTight - expected) < Math.abs(foundLoose - expected) ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)foundTight, (double)1.0E-8);
    }

    @Test
    public void compareFletcher1() {
        List<LineSearchEvaluator.Results> results = this.eval.fletcher1();
        TestLineSearchMore94.testResults(results.get(0), 3, 0.16);
        TestLineSearchMore94.testResults(results.get(1), 3, 0.16);
    }
}

