/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import java.util.Random;
import org.ddogleg.optimization.impl.EquationsBFGS;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.RandomMatrices;
import org.junit.Assert;
import org.junit.Test;

public class TestEquationsBFGS {
    Random rand = new Random(234L);

    @Test
    public void inverseUpdate() {
        int N = 6;
        DenseMatrix64F H = RandomMatrices.createSymmetric(N, -1.0, 1.0, this.rand);
        DenseMatrix64F s = RandomMatrices.createRandom(N, 1, -1.0, 1.0, this.rand);
        DenseMatrix64F y = RandomMatrices.createRandom(N, 1, -1.0, 1.0, this.rand);
        DenseMatrix64F tempV0 = new DenseMatrix64F(N, 1);
        DenseMatrix64F tempV1 = new DenseMatrix64F(N, 1);
        DenseMatrix64F expected = H.copy();
        DenseMatrix64F found = H.copy();
        EquationsBFGS.naiveInverseUpdate(expected, s, y);
        EquationsBFGS.inverseUpdate(found, s, y.copy(), tempV0, tempV1);
        Assert.assertTrue((boolean)MatrixFeatures.isIdentical(expected, found, 1.0E-8));
    }
}

