/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.CauchyStep;
import org.ejml.UtilEjml;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.junit.Assert;
import org.junit.Test;

public class TestCauchyStep {
    DenseMatrix64F J = new DenseMatrix64F(3, 2, true, 1.0, 0.0, 0.0, Math.sqrt(2.0), 0.0, 0.0);
    DenseMatrix64F x = new DenseMatrix64F(2, 1, true, 0.5, 1.5);
    DenseMatrix64F residuals = new DenseMatrix64F(3, 1, true, -1.0, -2.0, -3.0);
    DenseMatrix64F gradient = new DenseMatrix64F(2, 1);

    public TestCauchyStep() {
        CommonOps.multTransA(this.J, this.residuals, this.gradient);
    }

    @Test
    public void computeStep_inside() {
        CauchyStep alg = new CauchyStep();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(10.0, step);
        double a = TestCauchyStep.cost(this.residuals, this.J, step, 0.0);
        double b = TestCauchyStep.cost(this.residuals, this.J, step, 0.01);
        double c = TestCauchyStep.cost(this.residuals, this.J, step, -0.01);
        Assert.assertTrue((a < b ? 1 : 0) != 0);
        Assert.assertTrue((a < c ? 1 : 0) != 0);
    }

    public static double cost(DenseMatrix64F residuals, DenseMatrix64F J, DenseMatrix64F h, double delta) {
        DenseMatrix64F direction = h.copy();
        CommonOps.scale(1.0 / NormOps.normF(h), direction);
        h = h.copy();
        for (int i = 0; i < h.numRows; ++i) {
            int n = i;
            h.data[n] = h.data[n] + delta * direction.data[i];
        }
        DenseMatrix64F B = new DenseMatrix64F(J.numCols, J.numCols);
        CommonOps.multTransA(J, J, B);
        double left = VectorVectorMult.innerProd(residuals, residuals);
        double middle = VectorVectorMult.innerProdA(residuals, J, h);
        double right = VectorVectorMult.innerProdA(h, B, h);
        return 0.5 * left + middle + 0.5 * right;
    }

    @Test
    public void computeStep_outside() {
        CauchyStep alg = new CauchyStep();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(1.0, step);
        double l = NormOps.normF(step);
        Assert.assertTrue((Math.abs(l - 1.0) <= UtilEjml.EPS ? 1 : 0) != 0);
        double a = TestCauchyStep.cost(this.residuals, this.J, step, 0.0);
        double c = TestCauchyStep.cost(this.residuals, this.J, step, -0.01);
        Assert.assertTrue((a < c ? 1 : 0) != 0);
    }

    @Test
    public void predictedReduction_inside() {
        CauchyStep alg = new CauchyStep();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(10.0, step);
        double a = VectorVectorMult.innerProd(this.residuals, this.residuals) * 0.5;
        double c = TestCauchyStep.cost(this.residuals, this.J, step, 0.0);
        Assert.assertEquals((double)(a - c), (double)alg.predictedReduction(), (double)1.0E-8);
    }

    @Test
    public void predictedReduction_outside() {
        CauchyStep alg = new CauchyStep();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(1.0, step);
        double a = VectorVectorMult.innerProd(this.residuals, this.residuals) * 0.5;
        double c = TestCauchyStep.cost(this.residuals, this.J, step, 0.0);
        Assert.assertEquals((double)(a - c), (double)alg.predictedReduction(), (double)1.0E-8);
    }
}

