/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.LineSearch;
import org.ddogleg.optimization.functions.GradientLineFunction;
import org.ddogleg.optimization.impl.EquationsBFGS;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class QuasiNewtonBFGS {
    private int N;
    private double ftol;
    private double gtol;
    private GradientLineFunction function;
    private LineSearch lineSearch;
    private double funcMinValue;
    private double lineGTol;
    private double derivAtZero;
    private DenseMatrix64F B;
    private DenseMatrix64F searchVector;
    private DenseMatrix64F g;
    private DenseMatrix64F s;
    private DenseMatrix64F y;
    private DenseMatrix64F x;
    private double fx;
    private DenseMatrix64F temp0_Nx1;
    private DenseMatrix64F temp1_Nx1;
    private int mode;
    private String message;
    private boolean hasConverged;
    private int iterations;
    private boolean updated;
    double initialStep;
    double maxStep;
    boolean firstStep;

    public QuasiNewtonBFGS(GradientLineFunction function, LineSearch lineSearch, double funcMinValue) {
        this.lineSearch = lineSearch;
        this.funcMinValue = funcMinValue;
        this.function = function;
        lineSearch.setFunction(function);
        this.N = function.getN();
        this.B = new DenseMatrix64F(this.N, this.N);
        this.searchVector = new DenseMatrix64F(this.N, 1);
        this.g = new DenseMatrix64F(this.N, 1);
        this.s = new DenseMatrix64F(this.N, 1);
        this.y = new DenseMatrix64F(this.N, 1);
        this.x = new DenseMatrix64F(this.N, 1);
        this.temp0_Nx1 = new DenseMatrix64F(this.N, 1);
        this.temp1_Nx1 = new DenseMatrix64F(this.N, 1);
    }

    public void setConvergence(double ftol, double gtol, double lineGTol) {
        if (ftol < 0.0) {
            throw new IllegalArgumentException("ftol < 0");
        }
        if (gtol < 0.0) {
            throw new IllegalArgumentException("gtol < 0");
        }
        if (lineGTol <= 0.0) {
            throw new IllegalArgumentException("lineGTol <= 0");
        }
        this.ftol = ftol;
        this.gtol = gtol;
        this.lineGTol = lineGTol;
    }

    public void setInitialHInv(DenseMatrix64F Hinverse) {
        this.B.set(Hinverse);
    }

    public void initialize(double[] initial) {
        this.mode = 0;
        this.hasConverged = false;
        this.message = null;
        this.iterations = 0;
        this.s.zero();
        CommonOps.setIdentity(this.B);
        System.arraycopy(initial, 0, this.x.data, 0, this.N);
        this.function.setInput(this.x.data);
        this.fx = this.function.computeFunction();
        this.updated = false;
    }

    public double[] getParameters() {
        return this.x.data;
    }

    public boolean iterate() {
        this.updated = false;
        if (this.mode == 0) {
            return this.computeSearchDirection();
        }
        return this.performLineSearch();
    }

    private boolean computeSearchDirection() {
        this.function.computeGradient(this.temp0_Nx1.data);
        for (int i = 0; i < this.N; ++i) {
            this.y.data[i] = this.temp0_Nx1.data[i] - this.g.data[i];
            this.g.data[i] = this.temp0_Nx1.data[i];
        }
        if (this.iterations != 0) {
            EquationsBFGS.inverseUpdate(this.B, this.s, this.y, this.temp0_Nx1, this.temp1_Nx1);
        }
        CommonOps.mult(-1.0, this.B, this.g, this.searchVector);
        if (!this.setupLineSearch(this.fx, this.x.data, this.g.data, this.searchVector.data)) {
            this.resetMatrixB();
            CommonOps.mult(-1.0, this.B, this.g, this.searchVector);
            this.setupLineSearch(this.fx, this.x.data, this.g.data, this.searchVector.data);
        } else if (Math.abs(this.derivAtZero) <= this.gtol) {
            System.arraycopy(this.function.getCurrentState(), 0, this.x.data, 0, this.N);
            return this.terminateSearch(true, null);
        }
        this.mode = 1;
        ++this.iterations;
        return false;
    }

    private void resetMatrixB() {
        int i;
        double maxDiag = 0.0;
        for (i = 0; i < this.N; ++i) {
            double d = Math.abs(this.B.get(i, i));
            if (!(d > maxDiag)) continue;
            maxDiag = d;
        }
        this.B.zero();
        for (i = 0; i < this.N; ++i) {
            this.B.set(i, i, maxDiag);
        }
    }

    private boolean setupLineSearch(double funcAtStart, double[] startPoint, double[] startDeriv, double[] direction) {
        this.derivAtZero = 0.0;
        for (int i = 0; i < this.N; ++i) {
            this.derivAtZero += startDeriv[i] * direction[i];
        }
        if (this.derivAtZero > 0.0) {
            return false;
        }
        if (this.derivAtZero == 0.0) {
            return true;
        }
        this.function.setLine(startPoint, direction);
        this.maxStep = (this.funcMinValue - funcAtStart) / (this.lineGTol * this.derivAtZero);
        this.initialStep = 1.0 < this.maxStep ? 1.0 : this.maxStep;
        this.invokeLineInitialize(funcAtStart, this.maxStep);
        return true;
    }

    private void invokeLineInitialize(double funcAtStart, double maxStep) {
        this.function.setInput(this.initialStep);
        double funcAtInit = this.function.computeFunction();
        this.lineSearch.init(funcAtStart, this.derivAtZero, funcAtInit, this.initialStep, 0.0, maxStep);
        this.firstStep = true;
    }

    private boolean performLineSearch() {
        if (this.lineSearch.iterate()) {
            if (!this.lineSearch.isConverged()) {
                if (this.firstStep) {
                    this.initialStep /= 2.0;
                    if (this.initialStep != 0.0) {
                        this.invokeLineInitialize(this.fx, this.maxStep);
                        return false;
                    }
                    return this.terminateSearch(false, "Initial step reduced to zero");
                }
                return this.terminateSearch(false, this.lineSearch.getWarning());
            }
            this.firstStep = false;
            double step = this.lineSearch.getStep();
            System.arraycopy(this.function.getCurrentState(), 0, this.x.data, 0, this.N);
            for (int i = 0; i < this.N; ++i) {
                this.s.data[i] = step * this.searchVector.data[i];
            }
            this.updated = true;
            double fstp = this.lineSearch.getFunction();
            if (Math.abs(fstp - this.fx) <= this.ftol * Math.abs(this.fx) || Math.abs(this.derivAtZero) < this.gtol) {
                return this.terminateSearch(true, null);
            }
            if (fstp > this.fx) {
                throw new RuntimeException("Worse results!");
            }
            this.fx = fstp;
            this.mode = 0;
        }
        return false;
    }

    private boolean terminateSearch(boolean converged, String message) {
        this.hasConverged = converged;
        this.message = message;
        return true;
    }

    public boolean isConverged() {
        return this.hasConverged;
    }

    public String getWarning() {
        return this.message;
    }

    public double getFx() {
        return this.fx;
    }

    public boolean isUpdatedParameters() {
        return this.updated;
    }
}

