/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DenseMatrix64F;

public class EvalFuncPowell
implements EvalFuncLeastSquares {
    @Override
    public FunctionNtoM getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoMxN getJacobian() {
        return new Deriv();
    }

    @Override
    public double[] getInitial() {
        return new double[]{3.0, 1.0};
    }

    @Override
    public double[] getOptimal() {
        return new double[]{0.0, 0.0};
    }

    public static class Deriv
    implements FunctionNtoMxN {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return 2;
        }

        @Override
        public void process(double[] input, double[] output) {
            DenseMatrix64F J = DenseMatrix64F.wrap(2, 2, output);
            double x1 = input[0];
            double x2 = input[1];
            J.set(0, 0, 1.0);
            J.set(0, 1, 0.0);
            J.set(1, 0, 1.0 / Math.pow(x1 + 0.1, 2.0));
            J.set(1, 1, 4.0 * x2);
        }
    }

    public static class Func
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return 2;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            output[0] = x1;
            output[1] = 10.0 * x1 / (x1 + 0.1) + 2.0 * x2 * x2;
        }
    }
}

