/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.RegionStepType;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.impl.CauchyStep;
import org.ddogleg.optimization.impl.DoglegStepF;
import org.ddogleg.optimization.impl.DoglegStepFtF;
import org.ddogleg.optimization.impl.LevenbergDampened;
import org.ddogleg.optimization.impl.LevenbergMarquardtDampened;
import org.ddogleg.optimization.impl.TrustRegionLeastSquares;
import org.ddogleg.optimization.impl.TrustRegionStep;
import org.ddogleg.optimization.wrap.LevenbergDampened_to_UnconstrainedLeastSquares;
import org.ddogleg.optimization.wrap.QuasiNewtonBFGS_to_UnconstrainedMinimization;
import org.ddogleg.optimization.wrap.TrustRegionLeastSquares_to_UnconstrainedLeastSquares;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class FactoryOptimization {
    public static UnconstrainedMinimization unconstrained() {
        return new QuasiNewtonBFGS_to_UnconstrainedMinimization();
    }

    public static QuasiNewtonBFGS_to_UnconstrainedMinimization createBfgsWithMore94() {
        return new QuasiNewtonBFGS_to_UnconstrainedMinimization();
    }

    public static UnconstrainedLeastSquares leastSquaresLM(double dampInit, boolean robust) {
        LinearSolver<DenseMatrix64F> solver = robust ? LinearSolverFactory.pseudoInverse(true) : LinearSolverFactory.symmPosDef(10);
        LevenbergMarquardtDampened alg = new LevenbergMarquardtDampened(solver, dampInit);
        return new LevenbergDampened_to_UnconstrainedLeastSquares(alg);
    }

    public static UnconstrainedLeastSquares leastSquareLevenberg(double dampInit) {
        LevenbergDampened alg = new LevenbergDampened(dampInit);
        return new LevenbergDampened_to_UnconstrainedLeastSquares(alg);
    }

    public static UnconstrainedLeastSquares leastSquaresTrustRegion(double regionSize, RegionStepType type, boolean robustSolver) {
        TrustRegionStep stepAlg;
        switch (type) {
            case CAUCHY: {
                stepAlg = new CauchyStep();
                break;
            }
            case DOG_LEG_F: {
                if (robustSolver) {
                    stepAlg = new DoglegStepF(LinearSolverFactory.pseudoInverse(true));
                    break;
                }
                stepAlg = new DoglegStepF(LinearSolverFactory.leastSquaresQrPivot(true, false));
                break;
            }
            case DOG_LEG_FTF: {
                if (robustSolver) {
                    stepAlg = new DoglegStepFtF(LinearSolverFactory.pseudoInverse(true));
                    break;
                }
                stepAlg = new DoglegStepFtF(LinearSolverFactory.leastSquaresQrPivot(true, false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type = " + (Object)((Object)type));
            }
        }
        TrustRegionLeastSquares alg = new TrustRegionLeastSquares(regionSize, stepAlg);
        return new TrustRegionLeastSquares_to_UnconstrainedLeastSquares(alg);
    }
}

