/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class ExamineCubicInterpolateStability {
    public static double cubic(double a, double b, double alpha, double f0, double g0) {
        double alpha2 = alpha * alpha;
        double alpha3 = alpha2 * alpha;
        return a * alpha3 + b * alpha2 + alpha * g0 + f0;
    }

    public static double[] cubicDirect(double f0, double g0, double f1, double alpha1, double f2, double alpha2) {
        double denominator = alpha1 * alpha1 * alpha2 * alpha2 * (alpha2 - alpha1);
        double a11 = alpha1 * alpha1 / denominator;
        double a12 = -alpha2 * alpha2 / denominator;
        double a21 = -alpha1 * a11;
        double a22 = -alpha2 * a12;
        double y1 = f2 - f0 - g0 * alpha2;
        double y2 = f1 - f0 - g0 * alpha1;
        double[] ret = new double[]{a11 * y1 + a12 * y2, a21 * y1 + a22 * y2};
        return ret;
    }

    public static double[] cubicDirect2(double f0, double g0, double f1, double alpha1, double f2, double alpha2) {
        double a11 = 1.0 / (alpha2 * alpha2 * (alpha2 - alpha1));
        double a12 = -1.0 / (alpha1 * alpha1 * (alpha2 - alpha1));
        double a21 = -alpha1 / (alpha2 * alpha2 * (alpha2 - alpha1));
        double a22 = alpha2 / (alpha1 * alpha1 * (alpha2 - alpha1));
        double y1 = f2 - f0 - g0 * alpha2;
        double y2 = f1 - f0 - g0 * alpha1;
        double[] ret = new double[]{a11 * y1 + a12 * y2, a21 * y1 + a22 * y2};
        return ret;
    }

    public static double[] cubicLinear(double f0, double g0, double f1, double alpha1, double f2, double alpha2) {
        DenseMatrix64F A2 = new DenseMatrix64F(2, 2);
        A2.set(0, 0, alpha1 * alpha1 * alpha1);
        A2.set(0, 1, alpha1 * alpha1);
        A2.set(1, 0, alpha2 * alpha2 * alpha2);
        A2.set(1, 1, alpha2 * alpha2);
        DenseMatrix64F Y = new DenseMatrix64F(2, 1);
        Y.set(0, f1 - f0 - g0 * alpha1);
        Y.set(1, f2 - f0 - g0 * alpha2);
        DenseMatrix64F X = new DenseMatrix64F(2, 1);
        LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.linear(2);
        if (!solver.setA(A2)) {
            return X.data;
        }
        solver.solve(Y, X);
        return X.data;
    }

    private static void evaluate(double a, double b, double f0, double g0, double alpha1, double alpha2) {
        double f1 = ExamineCubicInterpolateStability.cubic(a, b, alpha1, f0, g0);
        double f2 = ExamineCubicInterpolateStability.cubic(a, b, alpha2, f0, g0);
        double[] direct = ExamineCubicInterpolateStability.cubicDirect(f0, g0, f1, alpha1, f2, alpha2);
        double[] direct2 = ExamineCubicInterpolateStability.cubicDirect2(f0, g0, f1, alpha1, f2, alpha2);
        double[] linear = ExamineCubicInterpolateStability.cubicLinear(f0, g0, f1, alpha1, f2, alpha2);
        double errorDirect = Math.abs(a - direct[0]) / Math.abs(a) + Math.abs(b - direct[1]) / Math.abs(b);
        double errorDirect2 = Math.abs(a - direct2[0]) / Math.abs(a) + Math.abs(b - direct2[1]) / Math.abs(b);
        double errorLinear = Math.abs(a - linear[0]) / Math.abs(a) + Math.abs(b - linear[1]) / Math.abs(b);
        System.out.println("Direct :  " + errorDirect);
        System.out.println("Direct2:  " + errorDirect2);
        System.out.println("Linear :  " + errorLinear);
    }

    public static void distanceAlpha(int N) {
        double a = 0.1;
        double b = 2.5;
        double f0 = 2.0;
        double g0 = -5.0;
        double alpha1 = 1.0;
        for (int i = 0; i < N; ++i) {
            double delta = 1.5 * Math.exp(-i);
            double alpha2 = alpha1 + delta;
            System.out.println("delta " + delta);
            ExamineCubicInterpolateStability.evaluate(a, b, f0, g0, alpha1, alpha2);
        }
    }

    public static void distanceScale(int N) {
        for (int i = 0; i < N; ++i) {
            double scale = Math.pow(10.0, -i);
            double a = 0.1;
            double b = 2.5;
            double f0 = 2.0;
            double g0 = -5.0;
            double alpha1 = 1.0 * scale;
            double alpha2 = 2.5 * scale;
            System.out.println("scale " + scale);
            ExamineCubicInterpolateStability.evaluate(a, b, f0, g0, alpha1, alpha2);
        }
    }

    public static void main(String[] args) {
        ExamineCubicInterpolateStability.distanceScale(20);
    }
}

