/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresEvaluator;
import org.ddogleg.optimization.impl.DoglegStepF;
import org.ddogleg.optimization.impl.TrustRegionLeastSquares;
import org.ddogleg.optimization.wrap.TrustRegionLeastSquares_to_UnconstrainedLeastSquares;

public class EvaluateTrustRegionLeastSquares
extends UnconstrainedLeastSquaresEvaluator {
    public EvaluateTrustRegionLeastSquares(boolean verbose) {
        super(verbose, false);
    }

    @Override
    protected UnconstrainedLeastSquares createSearch(double minimumValue) {
        TrustRegionLeastSquares alg = new TrustRegionLeastSquares(1.0, new DoglegStepF());
        return new TrustRegionLeastSquares_to_UnconstrainedLeastSquares(alg);
    }

    public static void main(String[] args) {
        EvaluateTrustRegionLeastSquares eval = new EvaluateTrustRegionLeastSquares(false);
        System.out.println("Powell              ----------------");
        eval.powell();
        System.out.println("Helical Valley      ----------------");
        eval.helicalValley();
        System.out.println("Rosenbrock          ----------------");
        eval.rosenbrock();
        System.out.println("Rosenbrock Mod      ----------------");
        eval.rosenbrockMod(Math.sqrt(2000000.0));
        System.out.println("variably            ----------------");
        eval.variably();
        System.out.println("trigonometric       ----------------");
        eval.trigonometric();
        System.out.println("Bady Scaled Brown   ----------------");
        eval.badlyScaledBrown();
    }
}

