/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeSearchBestBinFirst;
import org.ddogleg.nn.alg.StandardKdTreeSearch1Tests;
import org.junit.Assert;
import org.junit.Test;

public class TestKdTreeSearchBestBinFirst {
    @Test
    public void checkMaxNodes() {
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        BBF alg = new BBF(0);
        alg.setTree(tree);
        KdTree.Node found = alg.findClosest(new double[]{12.0, 2.0});
        Assert.assertTrue((found == tree.root.left.right ? 1 : 0) != 0);
    }

    @Test
    public void multiTreeSearch() {
        KdTree[] forest = new KdTree[]{StandardKdTreeSearch1Tests.createTreeA(), new KdTree(2)};
        forest[1].root = new KdTree.Node(new double[]{12.0, 2.0}, null);
        BBF alg = new BBF(200);
        alg.setTrees(forest);
        KdTree.Node found = alg.findClosest(new double[]{12.0, 3.0});
        Assert.assertTrue((alg.numNodesSearched > 0 ? 1 : 0) != 0);
        Assert.assertTrue((found == forest[1].root ? 1 : 0) != 0);
    }

    private static class BBF
    extends KdTreeSearchBestBinFirst {
        private KdTree.Node bestNode;

        public BBF(int maxNodesSearched) {
            super(maxNodesSearched);
        }

        public KdTree.Node findClosest(double[] target) {
            this.bestNode = null;
            this._findClosest(target);
            return this.bestNode;
        }

        @Override
        protected void checkBestDistance(KdTree.Node node, double[] target) {
            double distanceSq = KdTree.distanceSq(node, target, this.N);
            if (distanceSq <= this.bestDistanceSq) {
                this.bestDistanceSq = distanceSq;
                this.bestNode = node;
            }
        }

        @Override
        protected boolean canImprove(double distanceSq) {
            return distanceSq <= this.bestDistanceSq;
        }
    }
}

