/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.junit.Assert;
import org.junit.Test;

public class TestKdTreeConstructor {
    @Test
    public void computeBranch() {
        DummySplitter splitter = this.createSplitter(1, 1, false);
        splitter.splitAxis = 1;
        splitter.splitPoint = new double[]{2.0, 3.0};
        KdTreeConstructor<Integer> alg = new KdTreeConstructor<Integer>(new KdTreeMemory(), 2, splitter);
        KdTree.Node n = alg.computeBranch(new ArrayList<double[]>(), null);
        Assert.assertTrue((n.point == splitter.splitPoint ? 1 : 0) != 0);
        Assert.assertTrue((n.split == splitter.splitAxis ? 1 : 0) != 0);
        Assert.assertTrue((n.data == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n.left.isLeaf());
        Assert.assertTrue((boolean)n.right.isLeaf());
        Assert.assertTrue((n.left.point == splitter.left.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((n.left.data == null ? 1 : 0) != 0);
        Assert.assertTrue((n.right.point == splitter.right.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((n.right.data == null ? 1 : 0) != 0);
    }

    @Test
    public void computeBranch_widthData() {
        DummySplitter splitter = this.createSplitter(1, 1, true);
        splitter.splitAxis = 1;
        splitter.splitPoint = new double[]{2.0, 3.0};
        splitter.splitData = 2;
        KdTreeConstructor<Integer> alg = new KdTreeConstructor<Integer>(new KdTreeMemory(), 2, splitter);
        KdTree.Node n = alg.computeBranch(new ArrayList<double[]>(), new ArrayList());
        Assert.assertTrue((n.point == splitter.splitPoint ? 1 : 0) != 0);
        Assert.assertTrue((n.split == splitter.splitAxis ? 1 : 0) != 0);
        Assert.assertTrue((n.data == splitter.splitData ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n.left.isLeaf());
        Assert.assertTrue((boolean)n.right.isLeaf());
        Assert.assertTrue((n.left.point == splitter.left.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((n.left.data == splitter.leftData.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((n.right.point == splitter.right.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((n.right.data == splitter.rightData.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void computeChild() {
        KdTreeConstructor alg = new KdTreeConstructor(2);
        ArrayList<double[]> points = new ArrayList<double[]>();
        ArrayList<Integer> data = new ArrayList<Integer>();
        KdTree.Node n = new KdTree.Node();
        n.point = new double[2];
        n.data = 1;
        KdTree.Node found = alg.computeChild(points, data);
        Assert.assertTrue((found == null ? 1 : 0) != 0);
        points.add(new double[2]);
        data.add(2);
        found = alg.computeChild(points, data);
        Assert.assertTrue((boolean)found.isLeaf());
        Assert.assertTrue((found.point == points.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((found.data == data.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void construct() {
        KdTreeConstructor<Integer> alg = new KdTreeConstructor<Integer>(new KdTreeMemory(), 2, this.createSplitter(1, 1, false));
        ArrayList<double[]> points = new ArrayList<double[]>();
        KdTree tree = alg.construct(points, null);
        Assert.assertTrue((tree.N == 2 ? 1 : 0) != 0);
        Assert.assertTrue((tree.root == null ? 1 : 0) != 0);
        points.add(new double[]{1.0, 2.0});
        tree = alg.construct(points, null);
        Assert.assertTrue((tree.N == 2 ? 1 : 0) != 0);
        Assert.assertTrue((tree.root.point == points.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tree.root.isLeaf());
        points.add(new double[]{1.0, 2.0, 4.0, 5.0});
        tree = alg.construct(points, null);
        Assert.assertTrue((tree.N == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tree.root.left.isLeaf());
        Assert.assertTrue((boolean)tree.root.right.isLeaf());
    }

    public static List<double[]> createPoints(int dimen, double ... v) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        for (int i = 0; i < v.length; i += dimen) {
            double[] p = new double[dimen];
            for (int j = 0; j < dimen; ++j) {
                p[j] = v[i + j];
            }
            ret.add(p);
        }
        return ret;
    }

    private DummySplitter createSplitter(int numLeft, int numRight, boolean withData) {
        int i;
        ArrayList<double[]> left = new ArrayList<double[]>();
        ArrayList<double[]> right = new ArrayList<double[]>();
        ArrayList<Integer> leftData = null;
        ArrayList<Integer> rightData = null;
        for (i = 0; i < numLeft; ++i) {
            left.add(new double[2]);
        }
        for (i = 0; i < numRight; ++i) {
            right.add(new double[2]);
        }
        if (withData) {
            leftData = new ArrayList<Integer>();
            rightData = new ArrayList<Integer>();
            for (i = 0; i < numLeft; ++i) {
                leftData.add(i);
            }
            for (i = 0; i < numRight; ++i) {
                rightData.add(i);
            }
        }
        return new DummySplitter(null, null, 1, left, leftData, right, rightData);
    }

    public static class DummySplitter
    implements AxisSplitter<Integer> {
        boolean calledSetDimension = false;
        Integer splitData;
        double[] splitPoint;
        int splitAxis;
        List<double[]> left;
        List<Integer> leftData;
        List<double[]> right;
        List<Integer> rightData;

        public DummySplitter(Integer splitData, double[] splitPoint, int splitAxis, List<double[]> left, List<Integer> leftData, List<double[]> right, List<Integer> rightData) {
            this.splitData = splitData;
            this.splitPoint = splitPoint;
            this.splitAxis = splitAxis;
            this.left = left;
            this.leftData = leftData;
            this.right = right;
            this.rightData = rightData;
        }

        @Override
        public void setDimension(int N) {
            this.calledSetDimension = true;
        }

        @Override
        public void splitData(List<double[]> points, List<Integer> data, List<double[]> left, List<Integer> leftData, List<double[]> right, List<Integer> rightData) {
            left.addAll(this.left);
            right.addAll(this.right);
            if (leftData != null) {
                leftData.addAll(this.leftData);
            }
            if (rightData != null) {
                rightData.addAll(this.rightData);
            }
        }

        @Override
        public double[] getSplitPoint() {
            return this.splitPoint;
        }

        @Override
        public Integer getSplitData() {
            return this.splitData;
        }

        @Override
        public int getSplitAxis() {
            return this.splitAxis;
        }
    }
}

