/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.ExhaustiveNeighbor;
import org.ddogleg.nn.alg.TestKdTreeConstructor;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;
import org.junit.Assert;
import org.junit.Test;

public class TestExhaustiveNeighbor {
    @Test
    public void findClosest_zero() {
        ArrayList<double[]> list = new ArrayList<double[]>();
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        Assert.assertTrue((alg.findClosest(new double[]{1.0, 2.0}, 10.0) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_one() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        Assert.assertTrue((alg.findClosest(new double[]{1.0, 2.1}, 10.0) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((alg.findClosest(new double[]{1.0, 200.0}, 10.0) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_two() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 4.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        Assert.assertTrue((alg.findClosest(new double[]{1.0, 2.1}, 10.0) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_three() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 4.0, 6.0, 7.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        Assert.assertTrue((alg.findClosest(new double[]{3.1, 3.9}, 10.0) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void findClosestN_zero() {
        ArrayList<double[]> list = new ArrayList<double[]>();
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();
        alg.findClosestN(new double[]{1.0, 2.0}, 10.0, 5, outputIndex, outputDistance);
        Assert.assertEquals((long)0L, (long)outputIndex.size);
        Assert.assertEquals((long)0L, (long)outputDistance.size);
    }

    @Test
    public void findClosestN_toomany() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 4.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();
        alg.findClosestN(new double[]{1.0, 2.0}, 10.0, 5, outputIndex, outputDistance);
        Assert.assertEquals((long)2L, (long)outputIndex.size);
        Assert.assertEquals((long)2L, (long)outputDistance.size);
        Assert.assertEquals((long)0L, (long)outputIndex.get(0));
        Assert.assertEquals((long)1L, (long)outputIndex.get(1));
    }

    @Test
    public void findClosestN_toomany_distance() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 4.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();
        alg.findClosestN(new double[]{1.0, 2.0}, 0.1, 5, outputIndex, outputDistance);
        Assert.assertEquals((long)1L, (long)outputIndex.size);
        Assert.assertEquals((long)1L, (long)outputDistance.size);
        Assert.assertEquals((long)0L, (long)outputIndex.get(0));
        Assert.assertEquals((double)0.0, (double)outputDistance.get(0), (double)1.0E-8);
    }

    @Test
    public void findClosestN_standard() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 4.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();
        alg.findClosestN(new double[]{4.1, 4.9}, 10.0, 3, outputIndex, outputDistance);
        Assert.assertEquals((long)3L, (long)outputIndex.size);
        Assert.assertEquals((long)3L, (long)outputDistance.size);
        this.checkContains(1, outputIndex);
        this.checkContains(2, outputIndex);
        this.checkContains(3, outputIndex);
    }

    @Test
    public void findClosestN_multiple_calls() {
        List<double[]> list = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 4.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        ExhaustiveNeighbor alg = new ExhaustiveNeighbor(2);
        alg.setPoints(list);
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();
        alg.findClosestN(new double[]{4.1, 4.9}, 10.0, 3, outputIndex, outputDistance);
        outputIndex.reset();
        outputDistance.reset();
        alg.findClosestN(new double[]{4.1, 4.9}, 10.0, 3, outputIndex, outputDistance);
        Assert.assertEquals((long)3L, (long)outputIndex.size);
        Assert.assertEquals((long)3L, (long)outputDistance.size);
        this.checkContains(1, outputIndex);
        this.checkContains(2, outputIndex);
        this.checkContains(3, outputIndex);
    }

    private void checkContains(int value, GrowQueue_I32 list) {
        for (int i = 0; i < list.size; ++i) {
            if (list.data[i] != value) continue;
            return;
        }
        Assert.fail((String)"couldn't find");
    }
}

