/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.AxisSplitRule;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.TestKdTreeConstructor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAxisSplitterMedian {
    List<double[]> left = new ArrayList<double[]>();
    List<double[]> right = new ArrayList<double[]>();
    List<Integer> leftData = new ArrayList<Integer>();
    List<Integer> rightData = new ArrayList<Integer>();

    @Before
    public void init() {
        this.left.clear();
        this.right.clear();
        this.leftData.clear();
        this.rightData.clear();
    }

    @Test
    public void splitData_one() {
        List<double[]> points = TestKdTreeConstructor.createPoints(2, 1.0, 2.0);
        AxisSplitterMedian alg = new AxisSplitterMedian(new DummyRule(0));
        alg.splitData(points, null, this.left, null, this.right, null);
        Assert.assertEquals((long)0L, (long)this.left.size());
        Assert.assertEquals((long)0L, (long)this.right.size());
    }

    @Test
    public void splitData_two() {
        List<double[]> points = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 5.0);
        AxisSplitterMedian alg = new AxisSplitterMedian(new DummyRule(0));
        alg.splitData(points, null, this.left, null, this.right, null);
        Assert.assertEquals((long)1L, (long)this.left.size());
        Assert.assertEquals((long)0L, (long)this.right.size());
        Assert.assertEquals((double)1.0, (double)this.left.get(0)[0], (double)1.0E-8);
    }

    @Test
    public void splitData_three() {
        List<double[]> points = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 5.0, -3.0, 4.0);
        AxisSplitterMedian alg = new AxisSplitterMedian(new DummyRule(0));
        alg.splitData(points, null, this.left, null, this.right, null);
        Assert.assertEquals((long)1L, (long)this.left.size());
        Assert.assertEquals((long)1L, (long)this.right.size());
        Assert.assertEquals((double)-3.0, (double)this.left.get(0)[0], (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)this.right.get(0)[0], (double)1.0E-8);
    }

    @Test
    public void splitData_split_point() {
        List<double[]> points = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 5.0, -3.0, 4.0);
        AxisSplitterMedian alg = new AxisSplitterMedian(new DummyRule(1));
        alg.splitData(points, null, this.left, null, this.right, null);
        Assert.assertEquals((long)1L, (long)alg.getSplitAxis());
        Assert.assertEquals((double)-3.0, (double)alg.getSplitPoint()[0], (double)1.0E-8);
        Assert.assertTrue((null == alg.getSplitData() ? 1 : 0) != 0);
    }

    @Test
    public void splitData_withData() {
        List<double[]> points = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 3.0, 5.0, -3.0, 4.0);
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (int i = 0; i < points.size(); ++i) {
            data.add(i);
        }
        AxisSplitterMedian<Integer> alg = new AxisSplitterMedian<Integer>(new DummyRule(1));
        alg.splitData(points, data, this.left, this.leftData, this.right, this.rightData);
        Assert.assertEquals((long)1L, (long)this.left.size());
        Assert.assertEquals((long)1L, (long)this.right.size());
        Assert.assertEquals((long)1L, (long)this.leftData.size());
        Assert.assertEquals((long)1L, (long)this.rightData.size());
        Assert.assertEquals((double)1.0, (double)alg.getSplitAxis(), (double)1.0E-8);
        Assert.assertEquals((double)-3.0, (double)alg.getSplitPoint()[0], (double)1.0E-8);
        Assert.assertTrue((data.get(2) == alg.getSplitData() ? 1 : 0) != 0);
        Assert.assertTrue((data.get(0) == this.leftData.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((data.get(1) == this.rightData.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void identical_points() {
        List<double[]> points = TestKdTreeConstructor.createPoints(2, 1.0, 2.0, 1.1, 4.0, 1.0, 2.0);
        AxisSplitterMedian alg = new AxisSplitterMedian(new DummyRule(0));
        alg.splitData(points, null, this.left, null, this.right, null);
        Assert.assertEquals((long)1L, (long)this.left.size());
        Assert.assertEquals((long)1L, (long)this.right.size());
        Assert.assertEquals((double)1.0, (double)alg.getSplitPoint()[0], (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)this.left.get(0)[0], (double)1.0E-8);
        Assert.assertEquals((double)1.1, (double)this.right.get(0)[0], (double)1.0E-8);
    }

    @Test
    public void checkRuleSetCalled() {
        DummyRule rule = new DummyRule(2);
        AxisSplitterMedian alg = new AxisSplitterMedian(rule);
        alg.setDimension(2);
        Assert.assertTrue((boolean)rule.calledSetDimension);
    }

    private static class DummyRule
    implements AxisSplitRule {
        int which;
        boolean calledSetDimension = false;

        private DummyRule(int which) {
            this.which = which;
        }

        @Override
        public void setDimension(int N) {
            this.calledSetDimension = true;
        }

        @Override
        public int select(double[] variance) {
            return this.which;
        }
    }
}

