/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeSearch1;
import org.junit.Assert;
import org.junit.Test;

public abstract class StandardKdTreeSearch1Tests {
    public abstract KdTreeSearch1 createAlg();

    @Test
    public void findClosest_basic() {
        KdTreeSearch1 alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        KdTree.Node found = alg.findNeighbor(new double[]{11.0, 8.0});
        Assert.assertTrue((found == tree.root.right.right ? 1 : 0) != 0);
        found = alg.findNeighbor(new double[]{1.001, 1.99999});
        Assert.assertTrue((found == tree.root ? 1 : 0) != 0);
        found = alg.findNeighbor(new double[]{2.0, 0.8});
        Assert.assertTrue((found == tree.root.left.right ? 1 : 0) != 0);
        found = alg.findNeighbor(new double[]{-10000.0, 0.5});
        Assert.assertTrue((found == tree.root.left.left ? 1 : 0) != 0);
    }

    public static KdTree createTreeA() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        tree.root.split = 1;
        tree.root.left = new KdTree.Node(new double[]{-0.21, 1.0}, null);
        tree.root.left.split = 0;
        tree.root.left.left = new KdTree.Node(new double[]{-2.0, 0.5}, null);
        tree.root.left.left.split = -1;
        tree.root.left.right = new KdTree.Node(new double[]{2.0, 0.8}, null);
        tree.root.left.right.split = -1;
        tree.root.right = new KdTree.Node(new double[]{10.0, 5.0}, null);
        tree.root.right.split = 0;
        tree.root.right.left = new KdTree.Node(new double[]{10.0, 5.0}, null);
        tree.root.right.left.split = -1;
        tree.root.right.right = new KdTree.Node(new double[]{12.0, 10.0}, null);
        tree.root.right.right.split = -1;
        return tree;
    }

    @Test
    public void findClosest_nullLeaf() {
        KdTreeSearch1 alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeWithNull();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        KdTree.Node found = alg.findNeighbor(new double[]{2.0, 3.0});
        Assert.assertTrue((found == tree.root ? 1 : 0) != 0);
    }

    public static KdTree createTreeWithNull() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        tree.root.split = 1;
        tree.root.left = new KdTree.Node(new double[]{-0.2, 1.0}, null);
        tree.root.left.split = -1;
        tree.root.right = null;
        return tree;
    }

    @Test
    public void findClosest_empty() {
        KdTreeSearch1 alg = this.createAlg();
        alg.setTree(new KdTree(2));
        KdTree.Node found = alg.findNeighbor(new double[]{11.0, 8.0});
        Assert.assertTrue((found == null ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_leaf() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        KdTreeSearch1 alg = this.createAlg();
        alg.setTree(tree);
        KdTree.Node found = alg.findNeighbor(new double[]{11.0, 8.0});
        Assert.assertTrue((found == tree.root ? 1 : 0) != 0);
        found = alg.findNeighbor(new double[]{2.0, 5.0});
        Assert.assertTrue((found == tree.root ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_maxDistance() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        KdTreeSearch1 alg = this.createAlg();
        alg.setTree(tree);
        alg.setMaxDistance(2.0);
        KdTree.Node found = alg.findNeighbor(new double[]{11.0, 8.0});
        Assert.assertTrue((found == null ? 1 : 0) != 0);
        found = alg.findNeighbor(new double[]{1.0, 1.5});
        Assert.assertTrue((found == tree.root ? 1 : 0) != 0);
    }

    @Test
    public void checkDistance() {
        KdTreeSearch1 alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        double[] pt = new double[]{11.5, 8.2};
        KdTree.Node found = alg.findNeighbor(pt);
        double d0 = found.point[0] - pt[0];
        double d1 = found.point[1] - pt[1];
        Assert.assertEquals((double)(d0 * d0 + d1 * d1), (double)alg.getDistance(), (double)1.0E-8);
    }
}

