/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.AxisSplitRuleMax;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeMemory;

public class KdTreeConstructor<D> {
    private int N;
    AxisSplitter<D> splitter;
    KdTreeMemory memory;

    public KdTreeConstructor(KdTreeMemory memory, int N, AxisSplitter<D> splitter) {
        this.memory = memory;
        this.N = N;
        this.splitter = splitter;
        splitter.setDimension(N);
    }

    public KdTreeConstructor(int N) {
        this(new KdTreeMemory(), N, new AxisSplitterMedian(new AxisSplitRuleMax()));
    }

    public KdTree construct(List<double[]> points, List<D> data) {
        KdTree tree = this.memory.requestTree();
        tree.N = this.N;
        if (points.size() == 1) {
            tree.root = this.createLeaf(points, data);
        } else if (points.size() > 1) {
            tree.root = this.computeBranch(points, data);
        }
        return tree;
    }

    protected KdTree.Node computeBranch(List<double[]> points, List<D> data) {
        ArrayList rightData;
        ArrayList leftData;
        ArrayList<double[]> left = new ArrayList<double[]>(points.size() / 2);
        ArrayList<double[]> right = new ArrayList<double[]>(points.size() / 2);
        if (data == null) {
            leftData = null;
            rightData = null;
        } else {
            leftData = new ArrayList(points.size() / 2);
            rightData = new ArrayList(points.size() / 2);
        }
        this.splitter.splitData(points, data, left, leftData, right, rightData);
        KdTree.Node node = this.memory.requestNode();
        node.split = this.splitter.getSplitAxis();
        node.point = this.splitter.getSplitPoint();
        node.data = this.splitter.getSplitData();
        node.left = this.computeChild(left, leftData);
        left = null;
        leftData = null;
        node.right = this.computeChild(right, rightData);
        return node;
    }

    protected KdTree.Node computeChild(List<double[]> points, List<D> data) {
        if (points.size() == 0) {
            return null;
        }
        if (points.size() == 1) {
            return this.createLeaf(points, data);
        }
        return this.computeBranch(points, data);
    }

    private KdTree.Node createLeaf(List<double[]> points, List<D> data) {
        Object d = data == null ? null : data.get(0);
        return this.memory.requestNode(points.get(0), d);
    }
}

