/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.Random;
import org.ddogleg.nn.alg.AxisSplitRule;
import org.ddogleg.sorting.QuickSelect;

public class AxisSplitRuleRandomK
implements AxisSplitRule {
    Random rand;
    int N;
    int numConsiderSplit;
    int actualConsiderSplit;
    int[] indexes;

    public AxisSplitRuleRandomK(Random rand, int numConsiderSplit) {
        this.rand = rand;
        this.numConsiderSplit = numConsiderSplit;
    }

    @Override
    public void setDimension(int N) {
        this.N = N;
        this.indexes = new int[N];
        this.actualConsiderSplit = Math.min(this.numConsiderSplit, N);
    }

    @Override
    public int select(double[] variance) {
        for (int i = 0; i < this.N; ++i) {
            variance[i] = -variance[i];
        }
        QuickSelect.selectIndex(variance, this.actualConsiderSplit - 1, this.N, this.indexes);
        return this.indexes[this.rand.nextInt(this.actualConsiderSplit)];
    }
}

