/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn;

import java.util.ArrayList;
import java.util.Random;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.ExhaustiveNeighbor;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;
import org.junit.Assert;
import org.junit.Test;

public abstract class StandardNearestNeighborTests {
    Random rand = new Random(234L);
    NearestNeighbor<Double> alg;
    NnData found = new NnData();
    FastQueue<NnData<Double>> foundN = new FastQueue<NnData>(NnData.class, true);

    public void setAlg(NearestNeighbor<Double> alg) {
        this.alg = alg;
    }

    @Test
    public void findNearest_zero() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        this.alg.init(2);
        this.alg.setPoints(points, null);
        Assert.assertFalse((boolean)this.alg.findNearest(new double[]{1.0, 2.0}, 10.0, this.found));
    }

    @Test
    public void findNearest_one() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        this.alg.init(2);
        this.alg.setPoints(points, null);
        Assert.assertTrue((boolean)this.alg.findNearest(new double[]{1.0, 2.0}, 10.0, this.found));
        Assert.assertTrue((points.get(0) == this.found.point ? 1 : 0) != 0);
    }

    @Test
    public void findNearest_two() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        this.alg.init(2);
        this.alg.setPoints(points, null);
        Assert.assertTrue((boolean)this.alg.findNearest(new double[]{6.0, 7.0}, 10.0, this.found));
        Assert.assertTrue((points.get(1) == this.found.point ? 1 : 0) != 0);
    }

    @Test
    public void findNearest_checkData() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        ArrayList<Double> data = new ArrayList<Double>();
        data.add(3.0);
        data.add(7.0);
        this.alg.init(2);
        this.alg.setPoints(points, data);
        Assert.assertTrue((boolean)this.alg.findNearest(new double[]{6.0, 7.0}, 10.0, this.found));
        Assert.assertTrue((data.get(1) == this.found.data ? 1 : 0) != 0);
    }

    @Test
    public void findNearest_compareToNaive() {
        for (int numPoints = 10; numPoints <= 100; numPoints += 10) {
            ArrayList<double[]> points = new ArrayList<double[]>();
            for (int i = 0; i < numPoints; ++i) {
                points.add(this.randPoint(2));
            }
            this.alg.init(2);
            this.alg.setPoints(points, null);
            double[] where = this.randPoint(2);
            Assert.assertTrue((boolean)this.alg.findNearest(where, 10.0, this.found));
            ExhaustiveNeighbor exhaustive = new ExhaustiveNeighbor(2);
            exhaustive.setPoints(points);
            double[] expected = (double[])points.get(exhaustive.findClosest(where, 1000.0));
            Assert.assertTrue((expected == this.found.point ? 1 : 0) != 0);
        }
    }

    private double[] randPoint(int dimen) {
        double[] ret = new double[dimen];
        for (int i = 0; i < dimen; ++i) {
            ret[i] = this.rand.nextGaussian();
        }
        return ret;
    }

    @Test
    public void checkSetMaxDistance() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        points.add(new double[]{-1.0, 3.0});
        points.add(new double[]{0.9, 4.5});
        double[] target = new double[]{1.1, 3.9};
        this.alg.init(2);
        this.alg.setPoints(points, null);
        Assert.assertFalse((boolean)this.alg.findNearest(target, 0.01, this.found));
        Assert.assertFalse((boolean)this.alg.findNearest(target, 0.0, this.found));
        Assert.assertTrue((boolean)this.alg.findNearest((double[])points.get(3), 0.0, this.found));
        Assert.assertTrue((this.found.point == points.get(3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.alg.findNearest(target, -1.0, this.found));
        Assert.assertTrue((this.found.point == points.get(3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.alg.findNearest(target, 10.0, this.found));
        Assert.assertTrue((this.found.point == points.get(3) ? 1 : 0) != 0);
    }

    @Test
    public void checkSetMaxDistance_inclusive() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        points.add(new double[]{-1.0, 3.0});
        points.add(new double[]{0.9, 4.5});
        double[] target = new double[]{-2.0, 3.0};
        this.alg.init(2);
        this.alg.setPoints(points, null);
        Assert.assertTrue((boolean)this.alg.findNearest(target, 1.00000001, this.found));
        Assert.assertTrue((this.found.point == points.get(2) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.alg.findNearest(target, 1.0, this.found));
        Assert.assertTrue((this.found.point == points.get(2) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.alg.findNearest(target, 0.99999999, this.found));
    }

    @Test
    public void checkSetMaxDistance_inclusiveN() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        points.add(new double[]{-1.0, 3.0});
        points.add(new double[]{-3.0, 3.0});
        points.add(new double[]{0.9, 4.5});
        double[] target = new double[]{-2.0, 3.0};
        this.alg.init(2);
        this.alg.setPoints(points, null);
        this.foundN.reset();
        this.alg.findNearest(target, 1.00000001, 2, this.foundN);
        Assert.assertEquals((long)2L, (long)this.foundN.size());
        this.foundN.reset();
        this.alg.findNearest(target, 1.0, 2, this.foundN);
        Assert.assertEquals((long)2L, (long)this.foundN.size());
        this.foundN.reset();
        this.alg.findNearest(target, 0.99999999, 2, this.foundN);
        Assert.assertEquals((long)0L, (long)this.foundN.size());
    }

    @Test
    public void findNearest_checkDistance() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        points.add(new double[]{-1.0, 3.0});
        points.add(new double[]{0.9, 4.5});
        double[] target = new double[]{1.1, 3.9};
        this.alg.init(2);
        this.alg.setPoints(points, null);
        Assert.assertTrue((boolean)this.alg.findNearest(target, 10.0, this.found));
        double d0 = this.found.point[0] - target[0];
        double d1 = this.found.point[1] - target[1];
        Assert.assertEquals((double)(d0 * d0 + d1 * d1), (double)this.found.distance, (double)1.0E-8);
    }

    @Test
    public void findNearestN_checkDistance() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        points.add(new double[]{-1.0, 3.0});
        points.add(new double[]{0.9, 4.5});
        double[] target = new double[]{1.1, 3.9};
        this.alg.init(2);
        this.alg.setPoints(points, null);
        this.foundN.reset();
        this.alg.findNearest(target, 10.0, 1, this.foundN);
        Assert.assertEquals((long)1L, (long)this.foundN.size());
        double d0 = this.foundN.get((int)0).point[0] - target[0];
        double d1 = this.foundN.get((int)0).point[1] - target[1];
        Assert.assertEquals((double)(d0 * d0 + d1 * d1), (double)this.foundN.get((int)0).distance, (double)1.0E-8);
    }

    @Test
    public void findNearestN_checkData() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        ArrayList<Double> data = new ArrayList<Double>();
        data.add(3.0);
        data.add(7.0);
        this.alg.init(2);
        this.alg.setPoints(points, data);
        this.foundN.reset();
        this.alg.findNearest(new double[]{6.0, 7.0}, 10.0, 1, this.foundN);
        Assert.assertTrue((data.get(1) == this.foundN.get((int)0).data ? 1 : 0) != 0);
    }

    @Test
    public void findNearestN_compareToNaive() {
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();
        for (int i = 0; i < 200; ++i) {
            int numPoints = 8 + this.rand.nextInt(100);
            int numNeighbors = 1 + this.rand.nextInt(10);
            ArrayList<double[]> points = new ArrayList<double[]>();
            for (int j = 0; j < numPoints; ++j) {
                points.add(this.randPoint(2));
            }
            this.alg.init(2);
            this.alg.setPoints(points, null);
            double[] where = this.randPoint(2);
            this.foundN.reset();
            this.alg.findNearest(where, 10.0, numNeighbors, this.foundN);
            Assert.assertTrue((this.foundN.size <= numNeighbors ? 1 : 0) != 0);
            ExhaustiveNeighbor exhaustive = new ExhaustiveNeighbor(2);
            exhaustive.setPoints(points);
            outputIndex.reset();
            outputDistance.reset();
            exhaustive.findClosestN(where, 10.0, numNeighbors, outputIndex, outputDistance);
            Assert.assertEquals((long)outputIndex.size(), (long)this.foundN.size());
            for (int j = 0; j < outputIndex.size(); ++j) {
                double[] expected = (double[])points.get(outputIndex.get(j));
                boolean failed = true;
                for (int k = 0; k < this.foundN.size(); ++k) {
                    if (this.foundN.get((int)k).point != expected) continue;
                    failed = false;
                    break;
                }
                Assert.assertFalse((boolean)failed);
            }
        }
    }

    @Test
    public void findNearestN_duplicates() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{3.0, 4.0});
        points.add(new double[]{6.0, 8.0});
        ArrayList<Double> data = new ArrayList<Double>();
        data.add(3.0);
        data.add(3.1);
        data.add(3.2);
        data.add(3.3);
        data.add(3.4);
        data.add(7.0);
        this.alg.init(2);
        this.alg.setPoints(points, data);
        this.foundN.reset();
        this.alg.findNearest(new double[]{6.0, 7.0}, 50.0, 5, this.foundN);
        Assert.assertEquals((long)5L, (long)this.foundN.size());
        for (int i = 0; i < this.foundN.size(); ++i) {
            double[] a = this.foundN.get((int)i).point;
            for (int j = i + 1; j < this.foundN.size(); ++j) {
                if (a != this.foundN.get((int)j).point) continue;
                Assert.fail((String)"found duplicate");
            }
        }
    }
}

