/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.ddogleg.graph.Edge;
import org.ddogleg.graph.Node;

public class GraphDataManager<N, E> {
    protected List<Edge<N, E>> usedEdges = new ArrayList<Edge<N, E>>();
    protected Stack<Edge<N, E>> unusedEdges = new Stack();
    protected List<Node<N, E>> usedNodes = new ArrayList<Node<N, E>>();
    protected Stack<Node<N, E>> unusedNodes = new Stack();

    public void reset() {
        this.unusedEdges.addAll(this.usedEdges);
        this.unusedNodes.addAll(this.usedNodes);
        this.usedEdges.clear();
        this.usedNodes.clear();
    }

    public void resetHard() {
        int i;
        for (i = 0; i < this.usedEdges.size(); ++i) {
            Edge<N, E> e = this.usedEdges.get(i);
            e.data = null;
            e.dest = null;
        }
        for (i = 0; i < this.usedNodes.size(); ++i) {
            Node<N, E> n = this.usedNodes.get(i);
            n.data = null;
            n.edges.reset();
        }
        this.unusedEdges.addAll(this.usedEdges);
        this.unusedNodes.addAll(this.usedNodes);
        this.usedEdges.clear();
        this.usedNodes.clear();
    }

    public Edge<N, E> createEdge() {
        Edge e = this.unusedEdges.isEmpty() ? new Edge() : this.unusedEdges.pop();
        this.usedEdges.add(e);
        return e;
    }

    public void recycleEdge(Edge<N, E> e) {
        if (!this.usedEdges.remove(e)) {
            throw new IllegalArgumentException("The edge is not in the used list!");
        }
        this.unusedEdges.add(e);
    }

    public Node<N, E> createNode() {
        Node n = this.unusedNodes.isEmpty() ? new Node() : this.unusedNodes.pop();
        this.usedNodes.add(n);
        return n;
    }

    public void recycleNode(Node<N, E> n) {
        if (!this.usedNodes.remove(n)) {
            throw new IllegalArgumentException("The edge is not in the used list!");
        }
        this.unusedNodes.add(n);
    }
}

