/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.example;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.ddogleg.example.DistanceFromLine;
import org.ddogleg.example.Line2D;
import org.ddogleg.example.LineGenerator;
import org.ddogleg.example.LineManager;
import org.ddogleg.example.Point2D;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class ExampleRobustModelFit {
    public static void main(String[] args) {
        LineManager manager = new LineManager();
        LineGenerator generator = new LineGenerator();
        DistanceFromLine distance = new DistanceFromLine();
        Ransac<Line2D, Point2D> alg = new Ransac<Line2D, Point2D>(234234L, manager, generator, distance, 500, 0.01);
        Random rand = new Random(234L);
        double lineX = -2.1;
        double lineY = 1.3;
        List<Point2D> points = ExampleRobustModelFit.generateObservations(rand, lineX, lineY);
        if (!alg.process(points)) {
            throw new RuntimeException("Robust fit failed!");
        }
        Line2D found = (Line2D)alg.getModelParameters();
        System.out.println("Found line   " + found);
        System.out.println("Actual line   x = " + lineX + " y = " + lineY);
        System.out.println("Match set size = " + alg.getMatchSet().size());
    }

    private static List<Point2D> generateObservations(Random rand, double lineX, double lineY) {
        int i;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (i = 0; i < 20; ++i) {
            double t = (rand.nextDouble() - 0.5) * 10.0;
            points.add(new Point2D(lineX + t * lineY, lineY - t * lineX));
        }
        for (i = 0; i < 5; ++i) {
            points.add(new Point2D(rand.nextGaussian() * 10.0, rand.nextGaussian() * 10.0));
        }
        Collections.shuffle(points);
        return points;
    }
}

