/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.List;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.struct.FastQueue;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;

public class GaussianLikelihoodManager {
    List<GaussianGmm_F64> mixtures;
    FastQueue<Likelihood> precomputes;
    LinearSolver<DenseMatrix64F> solver;
    DenseMatrix64F diff;

    public GaussianLikelihoodManager(final int pointDimension, List<GaussianGmm_F64> mixtures) {
        this.mixtures = mixtures;
        this.solver = LinearSolverFactory.symmPosDef(pointDimension);
        this.solver = new LinearSolverSafe<DenseMatrix64F>(this.solver);
        this.precomputes = new FastQueue<Likelihood>(Likelihood.class, true){

            @Override
            protected Likelihood createInstance() {
                return new Likelihood(pointDimension);
            }
        };
        this.diff = new DenseMatrix64F(pointDimension, 1);
    }

    public void precomputeAll() {
        this.precomputes.resize(this.mixtures.size());
        for (int i = 0; i < this.precomputes.size; ++i) {
            this.precomputes.get(i).setGaussian(this.mixtures.get(i));
        }
    }

    public Likelihood getLikelihood(int which) {
        return this.precomputes.get(which);
    }

    public class Likelihood {
        public GaussianGmm_F64 gaussian;
        public DenseMatrix64F invCov;
        public double leftSide;
        public double chisq;
        public boolean valid = false;

        public Likelihood(int N) {
            this.invCov = new DenseMatrix64F(N, N);
        }

        public void setGaussian(GaussianGmm_F64 gaussian) {
            this.gaussian = gaussian;
            if (!GaussianLikelihoodManager.this.solver.setA(gaussian.covariance)) {
                this.valid = false;
                return;
            }
            this.valid = true;
            GaussianLikelihoodManager.this.solver.invert(this.invCov);
            CholeskyDecomposition decomposition = (CholeskyDecomposition)GaussianLikelihoodManager.this.solver.getDecomposition();
            double det = decomposition.computeDeterminant().real;
            this.leftSide = 1.0 / Math.sqrt(det);
        }

        public double likelihood(double[] point) {
            if (!this.valid) {
                return 0.0;
            }
            int N = this.gaussian.mean.numRows;
            for (int i = 0; i < N; ++i) {
                GaussianLikelihoodManager.this.diff.data[i] = point[i] - this.gaussian.mean.data[i];
            }
            this.chisq = VectorVectorMult.innerProdA(GaussianLikelihoodManager.this.diff, this.invCov, GaussianLikelihoodManager.this.diff);
            return this.leftSide * Math.exp(-0.5 * this.chisq);
        }

        public double getChisq() {
            return this.chisq;
        }
    }
}

